/*
 * (C) Copyright 2002
 * Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Marius Groeger <mgroeger@sysgo.de>
 * Gary Jennejohn <gj@denx.de>
 *
 * Configuation settings for the SAMSUNG board.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef __CONFIG_H
#define __CONFIG_H

#include "kira/cpe.h"

/*
 * If we are developing, we might want to start armboot from ram
 * so we MUST NOT initialize critical regs like mem-timing ...
 */

#define CONFIG_INIT_CRITICAL	1	/* undef for developing */
#define CONFIG_KIRA 1

/*
 * High Level Configuration Options
 * (easy to change)
 */
#define CONFIG_ARM940T		1	/* This is an ARM940T core	*/
#define CONFIG_USE_IRQ		1   /* use (F)IRQs for turbo mode and FCs */

/*
 * Hardware drivers
 */
#define CONFIG_DRIVER_FTMAC100		1			/* we have a CS8900 on-board */
/*
 * select serial console configuration
 */
#define CONFIG_SERIAL1          1	    

#define _TFTPBOOT_CONFIG_BOOTCOMMAND "tftpboot"
#define _BIGPHYSAREA  "bigphysarea=1026"
#define _MEM_CONFIG_BOOTCOMMAND "bootm 0x80020000 0x80100000"

#define _JFFS_CONFIG_BOOTCOMMAND "fsload uImage ; bootm"

#define _HWID_CONFIG_BOOTDELAY 1

#include "PP_COMMON.h"

/* this must be included AFTER the definition of CONFIG_COMMANDS (if any) */
#include <cmd_confdefs.h>

#define CONFIG_SETUP_MEMORY_TAGS    1
#define CONFIG_CMDLINE_TAG	    1
#define CONFIG_INITRD_TAG	    1

#define CFG_MEMTEST_START	0x00100000	/* memtest works on	*/
#define CFG_MEMTEST_END		0x02000000	/* 01 - 32 MB in DRAM	*/

#undef  CFG_CLKS_IN_HZ		/* everything, incl board info, in Hz */

#define	CFG_LOAD_ADDR		0x00f00000	/* default load address	*/

/* the PWM TImer 4 uses a counter of 15625 for 10 ms, so we need */
/* it to wrap 100 times (total 1562500) to get 1 sec. */
 /* #define	CFG_HZ			1562500 */

#define CFG_HZ				APB_CLK			/*  timer clock frequency */

/* valid baudrates */
#define CFG_BAUDRATE_TABLE	{ 9600, 19200, 38400, 57600, 115200 }

#if defined(PP_FEAT_PDU)
#define CONFIG_BAYTECH_BAUDRATE 9600
#endif

/*-----------------------------------------------------------------------
 * Physical Memory Map
 */
#define CONFIG_NR_DRAM_BANKS	1	   /* we have 1 bank of DRAM */

#define PHYS_SDRAM_0		0x00000000 /* SDRAM Bank #0 */
#define PHYS_SDRAM_0_SIZE	0x02000000 /* 32 MB */

#define CFG_INIT_RAM_ADDR       0x00df0000
#define CFG_INIT_RAM_END        0x2000  /* End of used area in RAM */
#define CFG_GBL_DATA_SIZE       140     /* size in bytes reserved for initial data */


#define CFG_GBL_DATA_OFFSET     (CFG_INIT_RAM_END - CFG_GBL_DATA_SIZE)
#define CFG_INIT_SP_OFFSET      CFG_GBL_DATA_OFFSET

#define PHYS_FLASH_1		0x80000000 /* Flash Bank #0 */

#if defined(PP_FEAT_SPI_BOOT)
#define PHYS_FLASH_SIZE		0x00200000 /* 2 MB */
#else
#define PHYS_FLASH_SIZE		0x00800000 /* 8 MB */
#endif

#define CFG_FLASH_BASE		PHYS_FLASH_1

/*-----------------------------------------------------------------------
 * FLASH and environment organization
 */
#define CFG_MAX_FLASH_BANKS		1	/* max number of memory banks */
#if defined (PP_FEAT_SPI_BOOT)
#define CFG_MAX_FLASH_SECT		(128)
#define CFG_FLASH_PAGE_SIZE             256
#else
#define CFG_MAX_FLASH_SECT		(64)	/* max number of sectors on one chip */
#endif

/* timeout values are in ticks */
#define CFG_FLASH_ERASE_TOUT	(5*CFG_HZ) /* Timeout for Flash Erase */
#define CFG_FLASH_WRITE_TOUT	(5*CFG_HZ) /* Timeout for Flash Write */

#define CFG_MONITOR_BASE        0x0


#define        CFG_ENV_IS_IN_FLASH     1
#ifdef CFG_ENV_IS_IN_FLASH
#if defined (PP_FEAT_SPI_BOOT)
#define CFG_ENV_SECT_SIZE	(64*1024)
#else
# define CFG_ENV_SECT_SIZE      (128*1024) /* environment sector total size */
#endif
# ifdef PP_FEAT_JFFS2_ROOTFS
#  define CFG_ENV_SIZE		1024	/* environment size */
# else
#  define CFG_ENV_SIZE		512	/* environment size */
# endif
# define CFG_ENV_OFFSET		(CFG_MONITOR_BASE + CFG_MONITOR_LEN - CFG_ENV_SIZE - 0x10) 
/* CFG_ENV_ADDR is generated in environment.h */

# define CFG_CRC_OFFSET		(CFG_ENV_OFFSET - 4)
# define CFG_CRC_ADDR		(CFG_FLASH_BASE + CFG_CRC_OFFSET)
#endif

#ifdef PP_FEAT_SPI_BOOT
#ifdef PP_FEAT_JFFS2_ROOTFS
# define CFG_MONITOR_LEN         (CFG_ENV_SECT_SIZE*4) /* on KIRA the monitor is always 1 sector */
#else
# define CFG_MONITOR_LEN         (CFG_ENV_SECT_SIZE*2) /* on KIRA the monitor is always 1 sector */
#endif
#else
#ifdef PP_FEAT_JFFS2_ROOTFS
# define CFG_MONITOR_LEN         (CFG_ENV_SECT_SIZE*2) /* on KIRA the monitor is always 1 sector */
#else
# define CFG_MONITOR_LEN         (CFG_ENV_SECT_SIZE) /* on KIRA the monitor is always 1 sector */
#endif
#endif

/*-----------------------------------------------------------------------
 * Stack sizes
 *
 * The stack sizes are set up in start.S using the settings below
 */

/* the stacksize must be at least the monitor len,
 * because the complete first flash sector will be put into ram
 * during saveenv, so I set it monitor_len * 2
 */
#define CONFIG_STACKSIZE	(CFG_MONITOR_LEN * 2)	/* regular stack */
#ifdef CONFIG_USE_IRQ
#define CONFIG_STACKSIZE_IRQ	(2*1024)	/* IRQ stack */
#define CONFIG_STACKSIZE_FIQ	(2*1024)	/* FIQ stack */
#endif

/***************************
    define system clock 
 **************************/

#define CONFIG_SYS_CLK_DIVIDER    2
#define CONFIG_SYS_CLK_FREQ       101376000
/***************************
    define UART clock
**************************/
#define     CONFIG_UART_CLOCK    18432000        /* ASIC320 */

/***************************
    define flash bank
**************************/
#define CONFIG_FLASH_BANK 0   /* bank 0,1,2,3,4,5,6,7 */


#endif	/* __CONFIG_H */

#if 0
/* just for reference - keep this stuff for several days */
#define CONFIG_BOOTARGS    	"console=ttyS0,115200 root=/dev/nfs nfsroot=192.168.1.83:/home/chkr/Projects/arm/eric_firmware-main/lara_root_devel ip=192.168.1.47:192.168.1.83 init=/sbin/init rw bigphysarea=1026" 
#define CONFIG_ETHADDR			fe:77:66:55:11:7b
#define CONFIG_NETMASK          255.255.255.0
#define CONFIG_IPADDR			192.168.1.47
#define CONFIG_SERVERIP			192.168.1.83
#define CONFIG_BOOTFILE		"zImage.kira.cpe.chkr"
#define CONFIG_BOOTCOMMAND	"tftp; bootm"
#endif
