#ifndef CPE_FLASH_H
#define CPE_FLASH_H


#if 0
// --------------------------------------------------------------------
//		 flash
// --------------------------------------------------------------------
#define MX_MANUFACT				0x00c20000							//  manufacture id

	// --------------------------------------------------------------------
	//		device id
	// --------------------------------------------------------------------
#define MX_ID_29LV008T			0x3e
#define MX_ID_29LV008B			0x37
#define MX_ID_26F128J3TC                0x89


	// --------------------------------------------------------------------
	//		device id
	// --------------------------------------------------------------------
#define SST_ID_39VF080			0xd8
#define SST_ID_39VF016			0xd9

//----------------------------------------------------------------------
//               Intel flash
//----------------------------------------------------------------------
// intel flash device id
#define INTEL_ID_E28F128                0x18

#define INTEL_E28F128_SIZE             (0x1000000)

#endif
#define FLASH_SINGLE 	(0x00)
#define FLASH_DOUBLE 	(0x01)
#define FLASH_FOUR   	(0x02)

#define MX_Type         (0x01)
#define SST_Type        (0x02)
/* add by Charles Tsai */
#define Intel_Type      (0x03)
/* end add */


#define PROGRAM_OK                              (1)
#define PROGRAM_NOT_OK                          (-2)
#define FLASH_PROGRAM_DELAY_CYCLE               (50)
#define FLASH_PROGRAM_LOOP_COUNTER              (100)

void fLib_Flash_ReadID(unsigned flash_type, unsigned base, unsigned BusWidth, unsigned* DDI1, unsigned* DDI2);
void fLib_Flash_Reset(unsigned base, unsigned BusWidth);
void fLib_Flash_SectorErase(unsigned flash_type, unsigned base, unsigned BusWidth, unsigned sector);
void fLib_Flash_ChipErase(unsigned flash_type, unsigned base, unsigned BusWidth);
void fLib_Flash_ProgramWord(unsigned flash_type, unsigned base, unsigned address, unsigned data);
void fLib_Flash_ProgramHalfWord(unsigned flash_type, unsigned base, unsigned address, unsigned short data);
void fLib_Flash_ReadWord(unsigned address, volatile unsigned long* data);

#endif
