#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

extern unsigned long crc32 (unsigned long crc, const char *buf, unsigned int len);

#define CHUNK_SIZE	1024

int
main (int argc, char **argv)
{
    ssize_t readcnt = 0;
    size_t count = 0;
    char* buffer = NULL;
    int fd = 0;
    unsigned long crcsum;
    
    /* read input data */

    do {
	buffer = realloc(buffer, count + CHUNK_SIZE);
	
	readcnt = read(fd, &buffer[count], CHUNK_SIZE);
	count += readcnt;
    } while (readcnt != 0);

    crcsum = crc32(0, buffer, count);

    printf("CRC=0x%08lx\n", crcsum);

    free(buffer);
    return 0;
}
