#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int main(int argc, char* argv[])
{
    FILE *infile, *outfile;
    unsigned char buf[4];
    int i, total, count, readchar = EOF, endoffile;

    endoffile = 0;
    count = 0;
    if ((argc>2) && (argc<5)) {
        infile = fopen(argv[1],"rb");
        outfile = fopen(argv[2],"wb");
        /* if there is no <count> argument, assume a
        very big number to swap the whole file */
        if (argc == 3) total = 1000000000;
        else {
            total = atoi(argv[3]);
            if (total % 4) {
                printf("swap byte count must be a multiple of 4!");
                exit(1);
            }
        }
        while (!endoffile && (count < total)) {
            memset(buf, 0, 4);
            for (i=0;i<4;i++) {
                readchar=fgetc(infile);
                if (readchar==EOF) endoffile=-1;
                else buf[i]=(unsigned char)readchar;
                count++;
                if (endoffile) break;
            }
            for (i=0;i<4;i++) fputc(buf[3-i],outfile);
        }
        while (readchar != EOF) {
            readchar = fgetc(infile);
            if (readchar != EOF) fputc(readchar, outfile);
        }
        fclose(infile);
        fclose(outfile);
    } else {
        printf("Usage:\n");
        printf("swap_dwords <input> <output> [<swapcount>]\n");
        exit(1);
    }
    exit(0);
}

