#!/usr/bin/perl -w
# 
# used as filepp module in generating the menu part of the .asp pages
# 

use strict;

sub parse_menu_file($) {
    my $menu = ();
    my $akt_entry = {};

    my $menu_file = shift || die "no menu file supplied\n";

    open(MF, "<$menu_file") or die "can't open $menu_file";

    while (<MF>) {
	if (/^\s*$/) { next; }  # skip empty lines
	if (/^[^\s]+/) {
	    # process indented line - menu entry
	    $_ =~ s/^\s*(.*?)\s*$/$1/ ;
	    if ((my $menu_entry, my $icon) = split /\|/) {

	      if (defined $akt_entry->{"list"}) {
		  push @{$menu}, $akt_entry;
	      }
	      $akt_entry = {};
	      $akt_entry->{"list"} = ();
	      $akt_entry->{"name"} = $menu_entry;
	      $akt_entry->{"iconname"} = defined($icon) ? $icon : "";

	      ($akt_entry->{"shortname"} = $menu_entry) =~ s/\s//g;
	    }
	} else {
	    # process un-indented line - menu headline
	    $_ =~ s/^\s*(.*?)\s*$/$1/ ;
	    if (!defined $akt_entry->{"name"}) {
		next;
	    }
	    s/^[\s]*//g;
	    if ((my $menu_entry, my $html, my $target) = split /\|/) {
		next if (!defined $menu_entry);
		my $entry = {};
		# name to display
		$entry->{"name"} = $menu_entry;
		# name of .asp page
		if (defined $html) {
		    $entry->{"url"} = $html;
		}
		# name of target frame
		if (defined $target) {
		    $entry->{"target"} = $target;
		}
		push @{$akt_entry->{"list"}}, $entry;
	    }
	}
    }

    if (defined $akt_entry->{"list"}) {
	push @{$menu}, $akt_entry;
    }

    return $menu;
}

sub gen_menu($$) {
	# name of menu definition file
    my $menudef_file = shift;
	# name of current .asp page
    my $curr_page_fname     = shift;
	# ID of selected menu block
    my $sel_block_shortname;

    my $t = "";
    my $menu = parse_menu_file($menudef_file);

    $t .= "<td valign=\"top\" class=\"menu\">\n";
    $t .= "<table style=\"border-collapse:collapse\" cellpadding=\"0\" cellspacing=\"0\"><thead><tr><th></th></tr></thead><tfoot><tr><td></td></tr></tfoot>\n";
    $t .= "<tbody><tr style=\"height:35px;\"><td></td></tr></tbody>\n";
    for my $big_menu_item (@{$menu}) {
	my $block_name = $big_menu_item->{name};
	my $block_shortname = $big_menu_item->{shortname};
	my $block_iconname = $big_menu_item->{iconname};
	# set $is_block_sel, if the selected entry is in the current menu block
	my $is_block_sel = 0;
	for my $small_menu_item (@{$big_menu_item->{"list"}}) {
	    my $url = $small_menu_item->{'url'};
	    if ($curr_page_fname eq $small_menu_item->{'url'}) {
		$is_block_sel = 1;
		$sel_block_shortname = $block_shortname;
	    }
	}
	$t .= "<tbody><tr><td width=\"5\" align=\"right\"><img src=\"big_menu_bg_l.gif\"></td><td height=\"40\" class=\"menu_item\"><a class=\"menu_link\" href=\"javascript:toggleItem('$block_shortname')\"><img src=\"$block_iconname\" align=\"middle\" border=\"0\" alt=\"\">&nbsp;$block_name&nbsp;</a></td><td width=\"20\" align=\"left\"><img src=\"big_menu_bg_r.gif\"></td></tr></tbody>\n";
	$t .= "<tbody class=\"menublock\" id=\"$block_shortname\">\n";
	for my $small_menu_item (@{$big_menu_item->{"list"}}) {
	    my $sname = $small_menu_item->{'name'};
	    my $url = defined($small_menu_item->{'url'}) ? $small_menu_item->{'url'} : "";
	    my $item_is_sel = ($curr_page_fname eq $url);
	    my $url_base = $url;
	    $url_base =~ s/\.asp.*$//;
	    my $targetstr = defined($small_menu_item->{'target'}) ? "target=\"$small_menu_item->{'target'}\"" : "";
	    my $class;
	    my $item_image;
	    if ($item_is_sel) {
		# selected item
		$class = "sub_menu_item_sel";
		$item_image = "menu_item_highlight.gif";
	    } else {
		# unselected item
		$class = "sub_menu_item";
		$item_image = "menu_item_normal.gif";
	    }

	    $t .= "<tr><td colspan=\"3\"class=\"$class\">\n";
	    # add the link or static text if no url defined
	    if (defined($url)) {
		$t .= "  <a  $targetstr href=\"$url\" class=\"menu_link\"><img src=\"$item_image\" align=\"middle\" border=\"0\" alt=\"\">$sname</a>\n";
	    } else {
		$t .= "  $sname\n";
	    }
	    $t .= "</td></tr>\n";
	}
	$t .= "</tbody>\n";
    }
    $t .= "</table>\n";

    # emit JS to open selected menu block
    if (!defined($sel_block_shortname)) {
	# all menu blocks closed
	$sel_block_shortname = "";   
    }
    $t .= "<script type=\"text/javascript\">\n";
    $t .= "  <!--\n";
    $t .= "    setMenu(\"$sel_block_shortname\");\n";
    $t .= "  -->\n";
    $t .= "</script>\n";

    $t .= "</td>\n";

    return $t;
}

return 1;
#
###############################################################################
# Emacs
#
# Local Variables:
# cperl-indent-level:4
# cperl-continued-statement-offset:4
# cperl-continued-brace-offset:-4
# cperl-brace-offset:0
# cperl-brace-imaginary-offset:0
# cperl-label-offset:-2
# cperl-hairy:t
# perl-tab-always-indent:nil
# End:
###############################################################################
