/**
 * This is the global meta information describing our MO
 * Pls. don't forget to change (In the future this is going
 * to be the only place where to change things ;-)
 *
 * $Id: metadata.c,v 1.3 2004-04-20 14:03:23 chkr Exp $
 */

#include <pp/metadata.h>

static pp_perm_desc_t perms[] = {
    { "acl",         "User/Group Permissions",     {"view", "change"} },
    { "cert",        "SSL Certificate Management", {"allow", 0} },
    { "events_ipmi", "Event Log via IPMI",         {"view", "change"} },
    { "ft",          "File Transfer",              {"allow", 0} },
    { "fw",          "Firmware Update",            {"allow", 0} },
    { "ipmi_s",      "IPMI Settings",              {"view", "change"} },
    { "km_s",        "Keyboard/Mouse Settings",    {"view", "change"} },
    { "video_s",     "Video Settings",             {"view", "change"} },
    { "net_s",       "Network Settings",           {"view", "change"} },
    { "pc",          "Server Power Control",       {"allow", 0} },
    { "pc_s",        "Power Control Settings",     {"view", "change"} },
    { "rc",          "Remote Console Access",      {"allow", 0} },
    { "rc_s_enc",    "RC settings (Encoding)",     {"view", "change"} },
    { "rc_s_hk",     "RC settings (Hotkeys)",      {"view", "change"} },
    { "rc_s_mm",     "RC settings (Monitor Mode)", {"view", "change"} },
    { "reset",       "Board Reset",                {"allow", 0} },
    { "sec_s",       "Security Settings",          {"view", "change"} },
    { "serial_s",    "Serial Settings",            {"view", "change"} },
    { "snmp_s",      "SNMP Settings",              {"view", "change"} },
    { "status_ipmi", "Server Status via IPMI",     {"view", "change"} },
    { "telnet",      "Telnet Access",              {"view", "change"} },
    { "um",          "User/Group Management",      {"view", "change"} },
    { "vfloppy",     "Virtual Floppy Upload",      {"allow", 0} },
    { 0, 0, {0, 0} }
};

static pp_setting_desc_t settings[] = {
    { "rc_encoding",              "Transmission Encoding",     0 },
    { "rc_compress_rate",         "Compression Rate",          0 },
    { "rc_monitor_mode_enabled",  "Monitor Mode",              0 },
    { "rc_use_active_x",          "Active X",                  0 },
    { "rc_use_sunplugin",         "Sun Plugin",                0 },
    { "rc_mouse_relative",        "Single Mouse Mode",         0 },
    { "rc_mousesync_key",         "Mouse Synchronization Key", 1 },
    { "rc_mousesync_keycode",     "",                          1 },
    { "rc_hotkey",                "Button Key",                0 },
    { "rc_hotkeycode",            "",                          0 },
    { 0, 0, 0 }
};

static pp_capability_desc_t caps[] = {
    { "rc",            "Show Remote Console",       "/title_app.asp", 
      "acl::rc == +allow" },
    { "rc_opts",       "Remote Console Settings",   "/rc_settings.asp",
      "acl::rc_s_enc == +view || acl::rc_s_hk == +view || acl::rc_s_mm == +view" },
    { "telnet",        "Telnet Console",            "/telnet.asp",
      "acl::telnet == +allow" },
    { "state_ipmi",    "Status via IPMI",           "/status_ipmi.asp",
      "acl::status_ipmi == +view" },
    { "evts_ipmi",     "Event Log via IPMI",        "/events_ipmi.asp",
      "acl::status_ipmi == +view" },
    { "pwr_ctrl",      "Power Control",             "/powerctrl_lara.asp",
      "acl::pc == +allow" },
    { "pwr_opts",      "Power Control Settings",    "/powerctrl_settings.asp",
      "acl::pc_s == +view" },
    { "km_opts",       "Keyboard/Mouse Settings",   "/km_settings.asp",
      "acl::km_s == +view" },
    { "vid_opts",      "Video Settings",            "/video_settings.asp",
      "acl::video_s == +view" },
//    { "um_mgmt",       "User/Group Management",     "/um.asp",
//      "acl::um == +view" },
//    { "um_perms",      "User/Group Permissions",    "/acl.asp",
//      "acl::um == +view" },
    { "net_opts",      "Network Settings",          "/network.asp",
      "acl::net_s == +view" },
    { "serial_opts",   "Serial Port Settings",      "/serial.asp",
      "acl::serial_s == +view" },
    { "sec_opts",      "Security Settings",         "/security.asp",
      "acl::sec_s == +view" },
    { "snmp_opts",     "SNMP Settings",             "/snmp.asp",
      "acl::snmp_s == +view" },
    { "ipmi_opts",     "IPMI Settings",             "/ipmi.asp",
      "acl::ipmi_s == +view" },
//    { "ldap_opts",     "LDAP Settings",             "/ldap.asp",
//      "acl::net_s == +view" },
    { "board",         "Maintenance",               "/board.asp",
      "true" },
    { 0, 0, 0, 0 }
};

pp_meta_data_t pp_mo_meta_data = {
    perms, settings, caps
};

