/* ----------------------------------------------------------------------------
 * Links
 */

a:link    { color: #000000; }
a:visited { color: #000000; }
a:active  { color: #b4b408; }

.notice a:link    { color: #a51924; }
.notice a:visited { color: #a51924; }
.notice a:active  { color: #ffffff; }

a.menu_link:link {
      text-decoration: none;
}

a.menu_link:visited {
      text-decoration: none;
}

a.menu_link:active {
      text-decoration: none;
}

a.menu_link:hover {
      text-decoration: underline;
}

a.corner_link:link {
      color: #c0c0c0;
      text-decoration: none;
}

a.corner_link:visited {
      color: #c0c0c0;
      text-decoration: none;
}

a.corner_link:active {
      color: #c0c0c0;
      text-decoration: none;
}

a.corner_link:hover {
      color: #c0c0c0;
      text-decoration: underline;
}

/* ----------------------------------------------------------------------------
 * Menu
 */

.menu {
      background-color: #c80000;
      min-width: 200px;
      width: 200px;
      white-space: nowrap;
}

.menu_item {
      background-image: url(big_menu_bg_c.gif); 
      background-repeat: repeat;
      background-color: #c80000;
}

.menu_item a {
      color: #c0c0c0;
      font-weight: bold;
      white-space: nowrap;
}

.sub_menu_item, .sub_menu_item a {
      color: #c0c0c0;
      font-family : Arial, Helvetica, sans-serif;
      font-size : 10pt;
      font-weight : bold;
      padding-left: 10px;
      background-color: #c80000;
      max-width: 200px;
      overflow:hidden;
      white-space: nowrap;
}

.sub_menu_item_sel, .sub_menu_item_sel a {
      color: #c80000;
      font-family : Arial, Helvetica, sans-serif;
      font-size : 10pt;
      font-weight : bold;
      padding-left: 10px;
      background-color: #c0c0c0;
      max-width: 200px;
      overflow:hidden;
      white-space: nowrap;
}

/* ----------------------------------------------------------------------------
 * Dialogs
 */

.group {
      margin: 0 0.5em 0.5em 0.5em;
      padding: 0.3em 0.3em 0.3em 0.3em;
      border-color: #000000;
      border-style: solid;
      border-width: 1px;
      text-align: center;
}

.groupCaption {
      color : #80a0e0;
      text-decoration : none;
      font-size : 11pt;
      font-weight : bold;
      font-family : Arial, Helvetica, sans-serif;
}

table.dialogTable {
      background-color: #ffffff;
      white-space: nowrap;
      border-width: 0px;
      text-align: left;
      vertical-align: middle;
}

table.center {
      margin-left: auto;
      margin-right: auto;
}

/* ----------------------------------------------------------------------------
 * Message Boxes
 */

.noframebox {
      padding: 0.3em;
}

.framebox {
      padding: 0.3em;
      border-style: solid;
      border-color: #000000;
      border-width: 1px;
}

.nowrap { white-space: nowrap; }
.wrap { white-space: normal; }

.uppercase { text-transform:uppercase; }

.authHeading {
      color : #000000;
      text-decoration : none;
      font-size : 11pt;
      font-weight : bold;
      font-family : Arial, Helvetica, sans-serif;
}

.authLogo {
      display: compact;
}

.default {
      color : #80A0E0;
      text-align: justify;
      text-decoration : none;
      font-size : 10pt;
      font-family : Arial, Helvetica, sans-serif;
}

.notice {
      color : #a51924;
      text-align: justify;
      text-decoration : none;
      font-size : 11pt;
      font-family : Arial, Helvetica, sans-serif;
}

.error {
        color: #ff0000;
	text-decoration : none;
	font-size : 11pt;
	font-weight : bold;
	font-family : Arial, Helvetica, sans-serif;
}

.tiny {
	text-decoration : none;
	font-size : 8pt;
	font-family : Arial, Helvetica, sans-serif;
}

.normal {
	text-decoration : none;
	font-size : 10pt;
	font-family : Arial, Helvetica, sans-serif;
}

.mono { 
	font-family: monospace;
}

.bold {
	text-decoration : none;
	font-size : 10pt;
	font-weight : bold;
	font-family : Arial, Helvetica, sans-serif;
}

.emph   { font-weight : bold; }

.elem_l { text-align: right;  }
.elem_r { text-align: left;   }

.left   { text-align: left;   }
.center { text-align: center; }
.right  { text-align: right;  }

.indent { padding-left: 16px; }

.main {
      background-color : #ffffff;
      color: #000000;
      font-size: 10pt;
      font-family: Arial, Helvetica, sans-serif;
}

.rsp_message {
	color : #000000;
	text-decoration : none;
	text-align: center;
	font-size : 11pt;
	font-weight : bold;
	font-family : Arial, Helvetica, sans-serif;
	padding : 1em 0 1em 0;
}
/* 
 * Align table in rsp_message centered (table is used for formatting bulleted
 * list centered, but the bullets horizontally lined up)  
 */
.rsp_message table {
    margin-left:auto; margin-right:auto
}


.acldenyaccess   { color : #800000; }
.aclallowaccess  { color : #008000; }
.acldenychange   { color : #804000; }
.aclallowview    { color : #409040; }
.aclallowchange  { color : #008000; }
.aclgroupsetting { color : #000000; }

BODY {
	background-color : #ffffff;
	color : #000000;
	font-size : 10pt;
	font-family : Arial, Helvetica, sans-serif;
}

/* 
 * surrounding of the login page window 
 */
body.auth {
	background-color : #c80000;
}

/*
 * table which will be maximized 
 * to the whole screen
 */
table.surroundingTable {
      height: 100%;
      width: 100%;
      text-align: center;
} 


/* 
 * title area on top of the window
 */
body.title {
      background-color : #c80000;
}

HR {
      border: 0;
      color: #000000;
      background-color: #000000;
      height: 1px;
}

P {
	color : #000000;
	font-size : 10pt;
	font-family : Arial, Helvetica, sans-serif;
}

TABLE {
	background-repeat: no-repeat
}


/*
 * table with the login form elements
 */
.authInner {
      background-color : #ffffff;
}

.cb_field {
      width: 40px;
}

/* ----------------------------------------------------------------------------
 * Event Log
 */

.loggingTable {
      color: #000000;
      text-decoration: none;
      font-size: 10pt;
      font-family: Arial, Helvetica, sans-serif;
}

.loggingRowOdd  { background-color : #e7e7e7; }
.loggingRowEven { background-color : #ffffff; }
.loggingHeader  { background-color : #d4d4d4; }

/*
 * tables surrounding the form elements
 * and their cells
 */
table.pagetable {
      border-spacing : 0px;
}
table.pagetable tr td {
      background-color : #ffffff;
      padding : 5px;
}


TABLE.inner {
      background-color: #ffffff;
}

/*
 * standard table
 */
.stdtable th {padding-right: 10px;padding-left: 10px;}
.stdtable td {padding-right: 10px;padding-left: 10px;}

/* 
 * Some special definitions for colors not used in the web
 * pages but other parts of the software, to avoid using
 * a special file or other configuration method.
 * Important!
 * Leave the structure as is, just change the color, use
 * the standard 6 digit notation
 */
.specialcolor_cornerbg { color: #c80000; }
.specialcolor_cornerfg { color: #000000; }
.specialcolor_telnetbg { color: #ffffff; }
.specialcolor_telnetfg { color: #000000; }
.specialcolor_sshbg { color: #ffffff; }
.specialcolor_sshfg { color: #000000; }


/*-----------------------------------------------------------------------------------------------------
	Screenshot
-----------------------------------------------------------------------------------------------------*/

.screenshot_wrapper, .screenshot_wrapper a {
        text-decoration : none;
}

.screenshot, .screenshot a, a.screenshot {
        color: #ffffff;
        text-align: left;
        text-decoration : none;
        font-size : 20pt;
        font-weight : bold;
        font-family : Arial, Helvetica, sans-serif;
        background-color : #0000ff;
        width : 320px;
        height : 240px;
        padding-right: 15px;
        padding-left: 15px;
        padding-top: 15px;
        padding-bottom: 15px;
        cursor : pointer;
        white-space: normal;
}

