/*
 * Main content of the pages, main frame
 */
body {
	background-color : #ffffff;
	color : #000000;
	font-size : 10pt;
	font-family : Arial, Helvetica, sans-serif;
	text-decoration : none;
}

/* 
 * surrounding of the login page window 
 */
body.auth {
	background-color : #777777;
}

/* 
 * title area on top of the window
 */
body.title {
      background-color : #a0c0d0;
}

/*
 * table which will be maximized 
 * to the whole screen
 */
table.surroundingTable {
      height: 100%;
      width: 100%;
      text-align: center;
} 

/*
 * tables surrounding the form elements
 * and their cells
 */
table.pagetable {
      border-spacing : 0px;
}
table.pagetable tr td {
      background-color : #ffffff;
      padding : 5px;
}

td.leftSideMenu {
      background-color : #a0c0d0;
      min-width : 150px;
      width : 150px;
      white-space : nowrap;
}

/*
 * table with the login form elements
 */
table.authInner {
      background-color : #ffffff;
}

/*
 * logo for login page, may be hidden if not needed
 * (name of the image file has to be 'logo.gif')
 */
tbody.authLogo {
      display : compact;
}

/*
 * greeting heading on the login page
 */
.authHeading {
	color : #000000;
	text-decoration : none;
	font-size : 12pt;
	font-weight : bold;
	font-family : Arial, Helvetica, sans-serif;
}

/* 
 * menu on the left side (navigation) with the big icons 
 */
td.leftSideMenu {
      background-color : #a0c0d0;
      min-width : 150px;
      width : 150px;
      white-space : nowrap;
}

/* 
 * event log display table, with single special rows
 */
.loggingTable {
      color : #000000;
      text-decoration : none;
      font-size : 10pt;
      font-family : Arial, Helvetica, sans-serif;
}
.loggingRowOdd {
      background-color : #e7e7e7;
}
.loggingRowEven {
      background-color : #ffffff;
}
.loggingHeader {
      background-color : #d4d4d4;
}

/*
 * heading for a function group, 
 * a collections of settings on the settings pages
 */
.functionGroupHeading {
	color : #000000;
	text-decoration : none;
	font-size : 12pt;
	font-weight : bold;
	font-family : Arial, Helvetica, sans-serif;
}

.nobr {
	white-space: nowrap;
}

/*
 * standard text, normal (explicit style)
 * TODO remove this, replace with content
 */
.normal {
        color : #000000;
        text-decoration : none;
        font-size : 10pt;
        font-family : Arial, Helvetica, sans-serif;
}

/*
 * standard text, bold (explicit style)
 * TODO remove this, replace with content
 */
.bold {
	color : #000000;
	text-decoration : none;
	font-size : 10pt;
	font-weight : bold;
	font-family : Arial, Helvetica, sans-serif;
}

/*
 * standard text, monospaced (explicit style)
 * TODO remove this, replace with content
 */
.mono {
        font-family: monospace;
}

/*
 * info messages
 */
.rsp_message {
	color : #000000;
	text-decoration : none;
	font-size : 12pt;
	font-weight : bold;
	font-family : Arial, Helvetica, sans-serif;
}

/*
 * notices/warnings on settings pages
 */
.notice {
	color : #a51924;
	text-decoration : none;
	font-size : 12pt;
	font-weight : bold;
	font-family : Arial, Helvetica, sans-serif;
}

/*
 * error messages
 */
.error {
	color : #ff0000;
	text-decoration : none;
	font-size : 12pt;
	font-weight : bold;
	font-family : Arial, Helvetica, sans-serif;
}

/* 
 * text under the icons of the left side menu 
 * (additionally to .normal)
 */
.leftSideMenuText {
      white-space : nowrap;
}

/*
 * text of icons for the connect-link feature
 */
.connectLinkText {
	color : #000000;
	text-decoration : none;
	font-size : 7pt;
	font-family : Arial, Helvetica, sans-serif;
	text-align: center;
	vertical-align: middle;
}

/*
 * Permission denied message, shown when a user
 * doesn't have view permission on a page
 */
.permDeniedMessage {
      color : #AA2020;
      font-weight : bold;
      font-size : 16pt;
      font-family : Arial, Helvetica, sans-serif;
      text-align : center;
}

/*
 * the line between blocks of settings/functions
 * set to 'display : none' to remove its occurence
 */
hr.separatorBar {
      display : compact;
}

/* 
 * general link colors 
 */
a:link    { color : #000000; }
a:visited { color : #000000; }
a:active  { color : #b4b408; }

/* 
 * Some special definitions for colors not used in the web
 * pages but other parts of the software, to avoid using
 * a special file or other configuration method.
 * Important!
 * Leave the structure as is, just change the color, use
 * the standard 6 digit notation
 */
.specialcolor_cornerbg { color: #a0c0d0; }
.specialcolor_cornerfg { color: #000000; }
.specialcolor_telnetbg { color: #ffffff; }
.specialcolor_telnetfg { color: #000000; }


/*-----------------------------------------------------------------------------------------------------
	Screenshot
-----------------------------------------------------------------------------------------------------*/

.screenshot_wrapper, .screenshot_wrapper a {
        text-decoration : none;
}

.screenshot, .screenshot a, a.screenshot {
        color: #ffffff;
        text-align: left;
        text-decoration : none;
        font-size : 20pt;
        font-weight : bold;
        font-family : Arial, Helvetica, sans-serif;
        background-color : #0000ff;
        width : 320px;
        height : 240px;
        padding-right: 15px;
        padding-left: 15px;
        padding-top: 15px;
        padding-bottom: 15px;
        cursor : pointer;
        white-space: normal;
}

