/**
 * bmc_dev_app_channel.h
 *
 * Channel Commands for BMC App Device Header.
 * Implements the channel configuration ipmi commands and stores
 * volatile and non volatile channel configuration data. New
 * volatile configurations are automatically pushed to the channels
 * through the bmc_router.
 *
 * (c) 2005 Peppercon AG, Thomas Weber <tweb@peppercon.de>
 */

#ifndef __BMC_DEV_APP_CHANNEL_H__
#define __BMC_DEV_APP_CHANNEL_H__

#include <pp/bmc/bmc_router.h>

/* Initialize and register channel commands */
int pp_bmc_dev_app_channel_init(void);

/* Unregister and cleanup channel commands */
void pp_bmc_dev_app_channel_cleanup(void);

/**
 * Get the initial (volatile) configuration for the specified channel. This
 * configuration is read from the non volatile parameters in the config system.
 * @returns PP_SUC
 * @returns PP_ERR if the configuration could not be retrieved.
 */
int pp_bmc_dev_channel_get_config(unsigned char channel,
                                  pp_bmc_router_chan_adapter_config_t* config);


#endif /* !__BMC_DEV_APP_CHANNEL_H__ */
