/**
 * bmc_dev_event_msg_buff.h
 *
 * The file implements the event message buffer/queue.
 * 
 * (c) 2005 Peppercon AG, Yiche Hsu  <yiche@peppercon.com>
 */

#ifndef __BMC_DEV_EVENT_MSG_BUFF_H__
#define __BMC_DEV_EVENT_MSG_BUFF_H__


#include "bmc_dev_sel_nv.h"


/**
 * Initializes the BMC Event Message Buffer device and registers it at the BMC core.
 * @return PP_SUC if success
 *         PP_ERR if error
 */
int bmc_dev_event_msg_buf_init(void);

/**
 * Finishes the BMC Event Message Buffer device and unregisters it at the BMC core.
 */
void bmc_dev_event_msg_buf_cleanup(void);

/**
 * Add an event message to the buffer. The event will be dropped
 * silently if the buffer is full or disabled.
 */
void bmc_dev_event_msg_buf_add(sel_entry_t* e);

/**
 * Clear the event message buffer.
 */
void bmc_dev_event_msg_buf_clear(void);

/**
 * Set the event message buffer enable status. Value=1 enables
 * the event message buffer, 0 disables the buffer.
 */
void bmc_dev_event_msg_buf_enable_set(unsigned char value);

/**
 * Get the event message buffer enable status.
 */
unsigned char bmc_dev_event_msg_buf_enable_get(void);


#endif

