/**
 * \file bmc_dev_kvm.c
 *
 * Description: BMC OEM Device (Peppercon KVM)
 *
 * (c) 2004 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 */

#include "pp/base.h"
#include "pp/bmc/ipmi_cmd.h"
#include "pp/bmc/ipmi_err.h"
#include "pp/bmc/ipmi_sess.h"
#include "pp/bmc/bmc_imsg.h"
#include "pp/bmc/bmc_core.h"
#include "pp/bmc/bmc_router.h"
#include "pp/bmc/debug.h"
#include "bmc_dev_kvm.h"

/********************************************************************
 * KVM command handlers
 */

/*
 * Reset KVM
 */

static int kvm_cmd_reset_kvm(imsg_t* imsg)
{
    // TODO: implement it!
    return pp_bmc_router_resp_err(imsg, IPMI_ERR_SUCCESS);
}

/********************************************************************
 * KVM device command table
 */

static const dev_cmd_entry_t kvm_cmd_tab[] = {
    {
        .cmd_hndlr = kvm_cmd_reset_kvm,
        .netfn = IPMI_NETFN_KVM, .cmd = IPMI_CMD_RESET_KVM,
        .min_data_size = 0, .min_priv_level = IPMI_PRIV_USER // TODO OPERATOR
    },
    { .cmd_hndlr = NULL }
};

/********************************************************************
 * KVM device c'tor/d'tor
 */

int pp_bmc_dev_kvm_init()
{
    /* register all entries of cmd tab */
    if (PP_ERR == pp_bmc_core_reg_cmd_tab(kvm_cmd_tab)) return PP_ERR;
    
    pp_bmc_log_info("[KVM] device started");
    return PP_SUC;
}

void pp_bmc_dev_kvm_cleanup()
{
    /* unregister all entries of cmd tab */
    pp_bmc_core_unreg_cmd_tab(kvm_cmd_tab);

    pp_bmc_log_info("[KVM] device shut down");
}
