/**
 * \file bmc_dev_oem_amd.h
 *
 * Description: BMC AMD/OPMA-OEM Device
 *
 * (c) 2005 Peppercon AG, Michael Baumann <miba@peppercon.de>
 */

#ifndef __BMC_DEV_OEM_AMD_H__
#define __BMC_DEV_OEM_AMD_H__

/**
 * Initializes the BMC AMD-OEM device and registers it at the BMC core.
 *
 * @return PP_SUC (0) if success
 *         PP_ERR (-1) if error
 */
int pp_bmc_dev_oem_amd_init(void);

/**
 * Finishes the BMC AMD-OEM device and unregisters it at the BMC core.
 */
void pp_bmc_dev_oem_amd_cleanup(void);

#endif /* !__BMC_DEV_OEM_AMD_H__ */
