/**
 * \file bmc_dev_oem_msi.h
 *
 * Description: BMC MSI-OEM Device
 *
 * (c) 2005 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 */

#ifndef __BMC_DEV_OEM_MSI_H__
#define __BMC_DEV_OEM_MSI_H__

/**
 * Initializes the BMC MSI-OEM device and registers it at the BMC core.
 *
 * @return PP_SUC (0) if success
 *         PP_ERR (-1) if error
 */
int pp_bmc_dev_oem_msi_init(void);

/**
 * Finishes the BMC MSI-OEM device and unregisters it at the BMC core.
 */
void pp_bmc_dev_oem_msi_cleanup(void);

#endif /* !__BMC_DEV_OEM_MSI_H__ */
