/**
 * \file bmc_dev_oem_pp_rpc.h
 *
 * Description: BMC Peppercon OEM commands for RPC
 *
 * (c) 2005 Peppercon AG, Thomas Breitfeld <thomas@peppercon.de>
 */

#ifndef __BMC_DEV_OEM_PP_RPC_H__
#define __BMC_DEV_OEM_PP_RPC_H__

#define TURN_OFF      	  	0
#define TURN_ON      	  	1
#define LED_GREEN         	24
#define LED_RED         	48

typedef struct outlet_queue_s {
    unsigned int outlet[48];
    unsigned char in_idx;
    unsigned char out_idx;	
    int inactivity_timeout;           // session inactivity timeout handler, -1 = no active timeout    
} outlet_queue_t;

/**
 * Initializes the BMC  device and registers it at the BMC core.
 *
 * @return PP_SUC (0) if success
 *         PP_ERR (-1) if error
 */
int pp_bmc_dev_oem_pp_rpc_init(void);
void pp_bmc_dev_oem_pp_rpc_recover_pwr_state(void);

/**
 * Finishes the BMC  device and unregisters it at the BMC core.
 */
void pp_bmc_dev_oem_pp_rpc_cleanup(void);

#endif /* !__BMC_DEV_OEM_PP_RPC_H__ */

