/**
 * \file bmc_dev_oem_supermicro.h
 *
 * Description: BMC SUPERMICRO-OEM Device
 *
 * (c) 2006  Edward Pan<edwardp@supermicro.com>
 */

#ifndef __BMC_DEV_OEM_SUPERMICRO_H__
#define __BMC_DEV_OEM_SUPERMICRO_H__

/**
 * Initializes the BMC SUPERMICRO-OEM device and registers it at the BMC core.
 *
 * @return PP_SUC (0) if success
 *         PP_ERR (-1) if error
 */
int pp_bmc_dev_oem_supermicro_init(void);

/**
 * Finishes the BMC SUPERMICRO-OEM device and unregisters it at the BMC core.
 */
void pp_bmc_dev_oem_supermicro_cleanup(void);

#endif /* !__BMC_DEV_OEM_SUPERMICRO_H__ */
