/**
 * bmc_dev_pef_internals.h
 *
 * BMC Platform Event Filtering (PEF), Internal logic, filtering and
 * alert mechanisms.
 * 
 * (c) 2004 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 */

#ifndef __BMC_DEV_PEF_INTERNALS_H__
#define __BMC_DEV_PEF_INTERNALS_H__

/**
 * pef_internals initializer, called by pef init
 * - starts timer if necessary
 * - initializes queues
 */
int bmc_pef_init(void);

/**
 * pef_internals shutdown function, called by pef shutdown
 * - stop all timers
 * - clear all queues
 */
void bmc_pef_cleanup(void);

/**
 * Enable PEF.
 */
void bmc_pef_enable(void);

/**
 * Immediately disable PEF. This includes all timers, pending alerts,
 * simply everything.
 */
void bmc_pef_disable(void);

/**
 * Set a new id for the last bmc processed event.
 * (pef_internals updates nv configuration)
 */
void bmc_pef_set_lpe_bmc(unsigned short id);

/**
 * Set a new id for the last sms processed event.
 * (Notify only, no need to update nv configuration)
 */
void bmc_pef_set_lpe_sms(unsigned short id);

/**
 * Set a new timer interval.
 */
void bmc_pef_set_timer(unsigned char interval);

/**
 * Get the current timer interval. (Does not get
 * the remaining time)
 */
unsigned char bmc_pef_get_timer(void);


#endif
