/**
 * \file bmc_dev_sdrr.h
 *
 * Description: BMC Sensor Data Record Repository Device
 *
 * (c) 2004 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 */

#ifndef __BMC_DEV_SDR_H__
#define __BMC_DEV_SDR_H__

#include <pp/bmc/ipmi_sdr.h>

/**
 * Initializes the BMC SDR Repository Device and registers it at the BMC core.
 *
 * @return PP_SUC (0) if success
 *         PP_ERR (-1) if error
 */
int pp_bmc_dev_sdrr_init(void);

/**
 * Finishes the BMC SDR Repository Device and unregisters it at the BMC core.
 */
void pp_bmc_dev_sdrr_cleanup(void);

/**
 * Returns whether SDRR is in persistent or transient mode.
 * Transient mode is default unless user writes into SDRR,
 * what will cause a state change to persistent mode.
 */
int pp_bmc_sdrr_is_persistent(void);

/**
 * Lookup SDR by key. This is used by the sensor device to find
 * an SDR for a sensor and do initialization (init agent functionality)
 */
ipmi_sdr_header_t* pp_bmc_sdrr_lookup_by_key_sensor(ipmi_sdr_key_sensor_t*key);

/**
 * Adds a SDR, without going through an IPMI command.
 * If SDR is in persistent mode, error will be returned.
 *
 * @param sdr the SDR to add, memory will be duplicated
 * @return new record id under which the record was stored
 *         or -1 if error
 */
unsigned short pp_bmc_sdrr_add_sdr_transiently(ipmi_sdr_header_t* sdr);

#endif /* !__BMC_DEV_SDR_H__ */
