/**
 * bmc_seq_number.h
 *
 * bmc and channel unique sequence numbers generater
 * 
 * (c) 2004 Peppercon AG, 12/03/2004, tbr@peppecon.de
 */

#ifndef __PP_BMC_SEQ_NUMBER_H__
#define __PP_BMC_SEQ_NUMBER_H__

/**
 * Allocates unique sequence number for the given channel
 * a sequence number is a 6bit integer
 * @return sequence number
 *         -1 if no sequence number is available
 */
char pp_bmc_seqno_assign(unsigned char channel);

/**
 * releases a sequence number for the given channel
 */
void pp_bmc_seqno_release(char channel, unsigned char seqno);

#endif
