/**
 * \file bmc_config.h
 *
 * Description: BMC Configuration Stuff
 *
 * (c) 2004 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 */

#ifndef __BMC_CONFIG_H__
#define __BMC_CONFIG_H__

#include <pp/firmware.h>

#ifdef PP_BMC_LOCAL_TEST
#  define PP_BMC_FLASH_ROOT "flashdisk/bmc"
#else
#  define PP_BMC_FLASH_ROOT "/flashdisk/bmc"
#endif

/* some BMC constants */

/*
 * to be honest we are 0x55 on the KIM I2C bus, however putting
 * this here will confuse at least ipmitool, issueing bridge commands
 * when it is not supposed to do that.
 * We may think of really beeing slave addr 0x20 on the IPMB,
 * currently it will work since nobody is talking to us actively
 * on IPMB. We are expecting responses for bridged commands,
 * but for those request the adapter puts its slave addr as requestor.
 * refer to libpp_ipmb/src/ipmb_adapter.c
 */
#define PP_BMC_IPMB_ADDR 0x20 /* addr of BMC on IPMB */

#define PP_BMC_BRIDGE_RSP_TIMEOUT 5000 /* in ms */

/* IANA enterprise numbers, used for bmc_info and PETs  *
 * (http://www.iana.org/assignments/enterprise-numbers) */
#if defined (LARA_KIMMSI)
#define MANUFACTURER_ID     9091  /* IANA Enterprise Number of MSI */
#else /* LARA_KIMMSI */
#define MANUFACTURER_ID     10437 /* IANA Enterprise Number of Peppercon */
#endif /* LARA_KIMMSI */

/*
 * Version numbers
 */
/* some arbitrary mapping of our products to products ID */
#if defined (PRODUCT_LARA_BMC_TEST)
#  define PRODUCT_ID            1
#elif defined (PRODUCT_AMDDC)
#  define PRODUCT_ID            2 
#elif defined (PRODUCT_MSIDC)
#  define PRODUCT_ID            3
#elif defined (PRODUCT_SMIDC)
#  define PRODUCT_ID            4
#elif defined (PRODUCT_ICPMMD)
#  define PRODUCT_ID            5
#elif defined (PRODUCT_PDU)
#  define PRODUCT_ID            6
#elif defined (PRODUCT_ASMIDC)
#  define PRODUCT_ID            7
#else
#  define PRODUCT_ID            0 // unspecified
/* FIXME: How to handle context specific fixmes? */
/* FIXME: BMC product-id is unspecified for this product!! */
#endif
 
#define DEVICE_ID   PP_HWID_INT
#define DEVICE_REV  0x1     /* 4 bit */

/* Firmware Revision 1.0.0, maybe we should align this with the erla-fw revision? */
#define FIRMWARE_REV_MAJOR  pp_firmware_erla_version_major
#define FIRMWARE_REV_MINOR  pp_firmware_erla_version_minor

#define AUX_FIRMWARE_REV    pp_bin_to_bcd(pp_firmware_erla_build_nr)




#endif /* !__BMC_CONFIG_H__ */
