/**
 * \file bmc_event.h
 *
 * Description: BMC Event Handling functions
 *
 * (c) 2004 Peppercon AG, Michael Baumann <miba@peppercon.de>
 */

#ifndef __BMC_EVENT_H__
#define __BMC_EVENT_H__


/**
 * Receive a new event. The event will be dropped if it originates from
 * PCI Mgmt Bus or ICMB and the SEL is disabled. If the event is valid,
 * it will be stored in the SEL and forwarded to PEF.
 *
 *
 * @param is_swid	flag deciding if addr_swid is a software id
 * @param addr_swid	generator id, device generating the event message
 * @param sensor_type	sensor type according to spec tab 42-3
 *                      (use generic event type if no offset is specified)
 * @param sensor_no	unique sensor number
 * @param event_dir	event transition direction (0=Assertion, 1=Deassertion)
 * @param event_type	event/reading type according to spec tab 42-1 / 42-2
 * @param data1		event data byte 1, depends on sensor/event type, see tab 29-6 and 42-3
 * @param data2		event data byte 2, depends on sensor/event type, see tab 29-6 and 42-3
 * @param data3		event data byte 3, depends on sensor/event type, see tab 29-6 and 42-3
 */
void pp_bmc_receive_event(unsigned char is_swid, unsigned char addr_swid, 
			  unsigned char lun, unsigned char chan,
			  unsigned char sensor_type, unsigned char sensor_no,
			  unsigned char event_dir, unsigned char event_type,
			  unsigned char data1, unsigned char data2, unsigned char data3);

#endif /* __BMC_EVENT_H__ */
