/**
 * bmc_fru.h
 *
 * Direct access to FRU device,
 * i.e. without sending ipmi messages
 *
 * (c) 2005 Peppercon AG, 2005/6/21, tbr@peppecon.de
 */

#ifndef __PP_BMC_FRU_H__
#define __PP_BMC_FRU_H__

#include <unistd.h>

/**
 * read a piece of fru data of given length into given buffer
 * and return the number of actually read bytes.
 * return -1 (PP_ERR) if error.
 */
int pp_bmc_fru_read_data(void* buf, off_t offset, size_t n);
    
#endif /* __PP_BMC_FRU_H__ */
