/**
 * bmc_watchdog.h
 *
 * BMC watchdog callback API
 *
 * (c) 2006 Peppercon AG, inva@raritan.com
 */

#ifndef __PP_BMC_WATCHDOG_H__
#define __PP_BMC_WATCHDOG_H__

typedef enum {
    PP_BMC_DEV_WATCHDOG_SET,
    PP_BMC_DEV_WATCHDOG_RESET,
    PP_BMC_DEV_WATCHDOG_PRE_TIMEOUT,
    PP_BMC_DEV_WATCHDOG_TIMEOUT
} pp_bmc_dev_watchdog_event_t;

typedef void (*pp_bmc_dev_watchdog_cb_t)(pp_bmc_dev_watchdog_event_t event);

/**
 * Register a callback to be executed on watchdog state changes
 */
int pp_bmc_dev_watchdog_add_callback(pp_bmc_dev_watchdog_cb_t cb);

/**
 * Remove a previously registered callback
 */
int pp_bmc_dev_watchdog_rem_callback(pp_bmc_dev_watchdog_cb_t cb);


#endif // __PP_BMC_WATCHDOG_H__
