/**
 * \file ipmi_msg.h
 *
 * Description: IPMI Message Header Formats
 *
 * (c) 2004 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 */
 
#ifndef __IPMI_MSG_H__
#define __IPMI_MSG_H__

#include "pp/bmc/utils.h"

/**
 * IPMI Message Header layout (IPMB/ICMB/LAN/Serial)
 */
struct ipmi_msg_hdr_s {
    unsigned char rs_addr;
    BITFIELD2(unsigned char, rs_lun : 2, netfn : 6);
    unsigned char chk1;
    unsigned char rq_addr;
    BITFIELD2(unsigned char, rq_lun : 2, rq_seq : 6);
    unsigned char cmd;
    /* unsigned char data[1..n]; */
    /* unsigned char chk2; */
} __attribute__ ((packed));
typedef struct ipmi_msg_hdr_s ipmi_msg_hdr_t;

#endif /* !__IPMI_MSG_H__ */
