/**
 * receive_message_queue.h
 *
 * The BMC receive message queue. Stores messages to the
 * system interface and creates the necessary status flag.
 *
 * (c) 2005 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 */

#ifndef __BMC_RECEIVE_MESSAGE_QUEUE_H__
#define __BMC_RECEIVE_MESSAGE_QUEUE_H__


#include <pp/bmc/bmc_imsg.h>


/**
 * Add a message to the tail of the receive message queue.
 * The receive message queue will take ownership of the memory.
 * @return PP_SUC
 * @return PP_ERR if the receive message queue is full
 *         and the message could not be stored.
 */
int bmc_receive_queue_add(imsg_t* imsg);

/**
 * Get a message from the head of the receive message queue.
 * The message will be permanently removed and the caller takes
 * responsibility of freeing it.
 * @return the message or NULL if the receive message
 *         queue is empty.
 */
imsg_t* bmc_receive_queue_get(void);

/**
 * Clear the receive message queue. All messages in the
 * queue are deleted.
 */
void bmc_receive_queue_clear(void);


/**
 * Initialize the receive message queue
 */
int bmc_receive_message_queue_init(void);

/**
 * Cleanup the receive message queue
 */
void bmc_receive_message_queue_cleanup(void);

#endif
