/**
 * lan_lowlevel.h
 *
 * (c) 2005 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 *
 * The lowlevel routines of the lan adapter. This code is
 * responsible for managing the socket and receiving
 * ip/udp packets either via a dedicated interface or
 * from the sideband link to the hosts nic.
 */

#ifndef __IPMI_LAN_LOWLEVEL_H__
#define __IPMI_LAN_LOWLEVEL_H__


#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <unistd.h>
#include <stdlib.h>


/**
 * send the specified payload as udp packet
 * @returns PP_ERR/PP_SUC
 */
int pp_bmc_lan_lowlevel_send(unsigned char* data, int len, struct sockaddr* addr, socklen_t* addr_len);

/**
 * Function handle to receive messages
 * @return PP_ERR/PP_SUC
 */
typedef int (*pp_bmc_lan_receive_handle_t)(unsigned char* data, int len, struct sockaddr* addr, socklen_t* addr_len);

/**
 * Set the lan receive handle. Only one receiver is supported. The existing
 * receiver handle is overwritten. If no handler is set, received messages
 * will be silently dropped.
 */
void pp_bmc_lan_lowlevel_set_handler(pp_bmc_lan_receive_handle_t lan_rcv_handler);

/**
 * Initialize the LAN lowlevel interface (hardware interface)
 * (Register in selector, etc);
 * @returns PP_ERR/PP_SUC
 */
int pp_bmc_lan_lowlevel_init(void);

/**
 * Cleanup the LAN interface
 * @returns PP_ERR/PP_SUC
 */
int pp_bmc_lan_lowlevel_cleanup(void);

#endif
