/**
 * lan_ipmi20.h
 *
 * (c) 2005 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 *
 * Handles the IPMIv20 messages for the ipmi class of RMCP+, including RAKP authentication.
 */

#ifndef __LAN_IPMI20_H__
#define __LAN_IPMI20_H__

#include "lan_ipmi15.h"

extern const char *PP_BMC_CHANNEL_ACCESS_KEYGEN_KEY;

/**
 * Handle IPMIv20 rmcp+ message data. Authenticate/decrypt the session and
 * forward payload.
 */
int pp_ipmi20_receive(unsigned char* data, int len, lan_addr_t* addr);

/**
 * Send IPMIv20 rmcp+ messages. Authenticate/encrypt and send the payload.
 */
int pp_ipmi20_send_payload(unsigned char* data, int datalen, unsigned char payload_type,
                           imsg_session_t* session, lan_addr_t* addr);

#endif
