/**
 * loopi_adapter_chan.h
 *
 * (c) 2006 Peppercon AG, 2006/8/3, tbr@raritan.com
 *
 * channel definitions for loopi adapter
 * supposed to be used in implementation files
 * do _not_ include this file under 'normal' circumstances
 */

#ifndef _PP_BMC_LOOPI_ADAPTER_CHAN_H
#define _PP_BMC_LOOPI_ADAPTER_CHAN_H

#include <pp/bmc/loopi_adapter.h>
#include <pp/bmc/ipmi_chan.h>

typedef struct pp_bmc_loopi_chan_s {
    int channel;
    const char* cmd_pipe;
    const char* rsp_pipe;
} pp_bmc_loopi_chan_t;

static pp_bmc_loopi_chan_t pp_bmc_loopi_chan[] = {
    /* PP_BMC_LOOPI_ERIC */
    { .channel = IPMI_CHAN_LOOP_ERIC,
      .cmd_pipe = "/tmp/bmc-eric_cmd_fifo",
      .rsp_pipe = "/tmp/bmc-eric_rsp_fifo"},
    /* PP_BMC_LOOPI_SNMPD */
    { .channel = IPMI_CHAN_LOOP_SNMPD,
      .cmd_pipe = "/tmp/bmc-snmpd_cmd_fifo", 
      .rsp_pipe = "/tmp/bmc-snmpd_rsp_fifo"},
#if defined (PP_FEAT_BAYTECH_2_IPMI)
    /* PP_BMC_LOOPI_BAYTECH */
    { .channel = IPMI_CHAN_LOOP_BAYTECH,
      .cmd_pipe = "/tmp/bmc-baytech_cmd_fifo",
      .rsp_pipe = "/tmp/bmc-baytech_rsp_fifo"}
#endif /* PP_FEAT_BAYTECH_2_IPMI */
};

#endif /* _PP_BMC_LOOPI_ADAPTER_CHAN_H */
