/**
 * adm1029.h
 *
 * implements the ADM1029 Monitor / Fan controller chip
 * This file includes all related objects (chip, sensors, pwm, gpio)
 * 
 * (c) 2005 Peppercon AG, 2005/10/28, thomas@peppercon.de
 */

#ifndef __PP_SENSOR_ADM1029_H__
#define __PP_SENSOR_ADM1029_H__

#include <pp/bmc/topo_base_obj.h>

#define ADM1029_MODEL_STRING "adm1029"

/* ppdoc
 * name:   ADM1029 chip
 * tpname: ADM1029
 * desc:   ADM1029 chip object. This object is needed for all ADM1029
 * desc:   sensors, pwms and gpios.
 * arg 0:  [OBJ(I2C_COM_DEV)] i2cdev: i2c device to be used
 * arg 1:  [INT] i2c_addr:            i2c slave address of this device
 * arg 2:  [OBJ(COND)] powercond:     power on condition (chip will be
 * arg 2:                             initialized if condition changes to on,
 * arg 2:                             sensors won't be read while cond is false)
 * arg 3:  [INT] fan1_cfg:            Fan 1 ticks per revolution (1, 2 or 4)
 * arg 4:  [INT] fan2_cfg:            Fan 2 ticks per revolution (1, 2 or 4)
 * arg 5:  [INT] gpio_mask:           GPIO mask, 7 bit, 1 enables according GPIO
 * arg 6:  [INT] gpio_dir:            GPIO in/out mask, 7 bit, 1 marks GPIO as output
 * return: [OBJ(I2C_CHIP)]
 */
pp_tp_obj_t* pp_sensor_adm1029_ctor(const char* id, vector_t* args);

/* ppdoc
 * name:   ADM1029 sensor
 * tpname: ADM1029Sens
 * desc:   The ADM1029 sensor object, can dissolve to different sensors
 * desc:   depending on the arguments. Needs the ADM1029 chip object, see ADM1029.
 * arg 0:  [OBJ(I2C_CHIP)] chip: i2c chip, must be an ADM1029
 * arg 1:  [INT] sensor_no:      sensor number
 * arg 1:                        0: Local Temp
 * arg 1:                        1: Remote Temp 1
 * arg 1:                        2: Remote Temp 2
 * arg 1:                        3: Tacho 1
 * arg 1:                        4: Tacho 2
 * return: [OBJ(SENS_DEV)]
 */
pp_tp_obj_t* pp_sensor_adm1029_sens_ctor(const char* id, vector_t* args);

/* ppdoc
 * name:   ADM1029 pwm actor
 * tpname: ADM1029PwmAct
 * desc:   A pwm actor for the ADM1029 pwms.
 * arg 0:  [OBJ(I2C_CHIP)] chip: i2c chip, must be an ADM1029
 * arg 1:  [INT] pwm_no:         pwm controller number within chip
 * arg 1:                        0: Drive 1
 * arg 1:                        1: Drive 2
 * return: [OBJ(PWM_ACT)]
 */
pp_tp_obj_t* pp_sensor_adm1029_pwm_ctor(const char* id, vector_t* args);

/* ppdoc
 * name:   ADM1029 GPIO device
 * tpname: ADM1029Gpio
 * desc:   ADM1029 GPIO device, can control the 7 GPIOs of the chip.
 * desc:   Note: currently only GPIO actors are implemented in this device.
 * desc:   GPIO sensors are not supported by this Implementation
 * arg 0:  [OBJ(I2C_CHIP)] chip: i2c chip, must be an ADM1029
 * return: [OBJ(GPIO_DEV)]
 */
pp_tp_obj_t* pp_sensor_adm1029_gpio_ctor(const char* id, vector_t* args);


/* some register symbols, as per spec ADM1029.pf */
#define ADM1029_STATUS_REGISTER 0x00
#define ADM1029_CONFIG_REGISTER 0x01
#define ADM1029_FAN_SUPPORTED_BY_CONTROLLER 0x02
#define ADM1029_FANS_SUPPORTED_IN_SYSTEM 0x03
#define ADM1029_GPIOS_SUPPORTED_BY_CONTROLLER 0x04
#define ADM1029_GPIO_PRESENT_AIN 0x05
#define ADM1029_TEMP_DEVICES_INSTALLED 0x06
#define ADM1029_SET_FAN_X_ALARM_SPEED 0x07
#define ADM1029_SET_FAN_X_HOT_PLUG_SPEED 0x08
#define ADM1029_SET_FAN_X_FULL_SPEED_ 0x09
#define ADM1029_SW_RESET_A6H_WRITING 0x0B
#define ADM1029_FAN_SPIN_UP 0x0C
#define ADM1029_MANUFACTURER_ID 0x0D
#define ADM1029_MAJOR_MINOR_REVISION 0x0E
#define ADM1029_MANUFACTURER_TEST_REGISTER 0x0F
#define ADM1029_FAN_1_STATUS 0x10
#define ADM1029_FAN_2_STATUS 0x11
#define ADM1029_FAN_1_FAULT_ACTION 0x18
#define ADM1029_FAN_2_FAULT_ACTION 0x19
#define ADM1029_FAN_1_EVENT_MASK 0x20
#define ADM1029_FAN_2_EVENT_MASK 0x21
#define ADM1029_GPIO0_BEHAVIOR 0x28
#define ADM1029_GPIO1_BEHAVIOR 0x29
#define ADM1029_GPIO2_BEHAVIOR 0x2A
#define ADM1029_GPIO3_BEHAVIOR 0x2B
#define ADM1029_GPIO4_BEHAVIOR 0x2C
#define ADM1029_GPIO5_BEHAVIOR 0x2D
#define ADM1029_GPIO6_BEHAVIOR 0x2E
#define ADM1029_LOCAL_TEMPERATURE_OFFSET 0x30
#define ADM1029_REMOTE_1_TEMPERATURE_OFFSET 0x31
#define ADM1029_REMOTE_2_TEMPERATURE_OFFSET 0x32
#define ADM1029_GPIO0_EVENT_MASK 0x38
#define ADM1029_GPIO1_EVENT_MASK 0x39
#define ADM1029_GPIO2_EVENT_MASK 0x3A
#define ADM1029_GPIO3_EVENT_MASK 0x3B
#define ADM1029_GPIO4_EVENT_MASK 0x3C
#define ADM1029_GPIO5_EVENT_MASK 0x3D
#define ADM1029_GPIO6_EVENT_MASK 0x3E
#define ADM1029_LOCAL_TEMP_FAULT_ACTION 0x40
#define ADM1029_REMOTE_1_TEMP_FAULT_ACTION 0x41
#define ADM1029_REMOTE_2_TEMP_FAULT_ACTION 0x42
#define ADM1029_LOCAL_TEMP_COOLING_ACTION 0x48
#define ADM1029_REMOTE_1_TEMP_COOLING_ACTION 0x49
#define ADM1029_REMOTE_2_TEMP_COOLING_ACTION 0x4A
#define ADM1029_AIN0_BEHAVIOR 0x50
#define ADM1029_AIN1_BEHAVIOR 0x51
#define ADM1029_AIN0_EVENT_MASK 0x58
#define ADM1029_AIN1_EVENT_MASK 0x59
#define ADM1029_FAN_1_MINIMUM_OR_ALARM_SPEED 0x60
#define ADM1029_FAN_2_MINIMUM_OR_ALARM_SPEED 0x61
#define ADM1029_FAN_1_CONFIGURATION 0x68
#define ADM1029_FAN_2_CONFIGURATION 0x69
#define ADM1029_FAN_1_TACH_VALUE 0x70
#define ADM1029_FAN_2_TACH_VALUE 0x71
#define ADM1029_FAN_1_TACH_HIGH_LIMIT 0x78
#define ADM1029_FAN_2_TACH_HIGH_LIMIT 0x79
#define ADM1029_LOCAL_TEMP_TMIN 0x80
#define ADM1029_REMOTE_1_TEMP_TMIN 0x81
#define ADM1029_REMOTE_2_TEMP_TMIN 0x82
#define ADM1029_LOCAL_TEMP_TRANGE_THYST 0x88
#define ADM1029_REMOTE_1_TEMP_TRANGE_THYST 0x89
#define ADM1029_REMOTE_2_TEMP_TRANGE_THYST 0x8A
#define ADM1029_LOCAL_TEMP_HIGH_LIMIT 0x90
#define ADM1029_REMOTE_1_TEMP_HIGH_LIMIT 0x91
#define ADM1029_REMOTE_2_TEMP_HIGH_LIMIT 0x92
#define ADM1029_LOCAL_TEMP_LOW_LIMIT_3CH 0x98
#define ADM1029_REMOTE_1_TEMP_LOW_LIMIT 0x99
#define ADM1029_REMOTE_2_TEMP_LOW_LIMIT 0x9A
#define ADM1029_LOCAL_TEMP_VALUE 0xA0
#define ADM1029_REMOTE_1_TEMP_VALUE 0xA1
#define ADM1029_REMOTE_2_TEMP_VALUE 0xA2
#define ADM1029_AIN0_HIGH_LIMIT 0xA8
#define ADM1029_AIN1_HIGH_LIMIT 0xA9
#define ADM1029_AIN0_LOW_LIMIT 0xB0
#define ADM1029_AIN1_LOW_LIMIT 0xB1
#define ADM1029_AIN0_MEASURED_VALUE 0xB8
#define ADM1029_AIN1_MEASURED_VALUE 0xB9

/* some default values (might be changeable, however we stay with the *
 * default for the time beeing                                        */
#define ADM1029_PWM_FREQUENCY_DEF 250 /* Hz */


#endif /* __PP_SENSOR_ADM1029_H__ */
