/**
 * adt7463_sensor.h
 *
 * "Super class" for all ADT7463 sensors
 * 
 * (c) 2005 Peppercon AG, 02/16/2005, thre@peppecon.de
 */

#ifndef __ADT7463_SENSOR_H
#define __ADT7463_SENSOR_H

#include <pp/vector.h>
#include <pp/base.h>

#include <pp/bmc/topo_base_obj.h>
#include <pp/bmc/tp_i2c_chip.h>


/* ppdoc:
 * name:   ADT7463 sensor
 * tpname: ADT7463sens
 * desc:   ADT7463 sensor object, dissolves to different sensors depending
 * desc:   on the arguments. Relies on an ADT7463 chip object.
 * arg 0: [OBJ(I2C_CHIP)] chip:  i2c chip to use, must be an ADT7463 chip object
 * arg 1: [INT] sensor_no:       sensor number within the chip, whereas:
 * arg 1:                         0: 5v
 * arg 1:                         1: 2_5v
 * arg 1:                         2: 12v
 * arg 1:                         3: vcc
 * arg 1:                         4: vccp
 * arg 1:                         5: tach1
 * arg 1:                         6: tach2
 * arg 1:                         7: tach3
 * arg 1:                         8: temp_local
 * arg 1:                         9: temp_remote1
 * arg 1:                        10: temp_remote2
 * arg 2: [OBJ(COND)] scan_cond: (optional) scan_condition, sensor won't be
 * arg 2:                        read if condition is false
 * return: [OBJ(SENS_DEV)]
 */
pp_tp_obj_t* pp_adt7463_sensor_ctor(const char* id, vector_t* args);

#define PP_SENSOR_ADT7463_MAX_SENSOR_NUM 10

#endif /* __ADT7463_SENSOR_H */
