/**
 * dummy_sensor.c
 *
 * some dummy sensors for testing purposes
 * 
 * (c) 2004 Peppercon AG, 12/16/2004, tbr@peppecon.de
 */
#include <stdlib.h>
#include <pp/base.h>

#include <pp/bmc/bmc_config.h>
#include <pp/bmc/ipmi_sdr.h>
#include <pp/bmc/ipmi_bits.h>
#include <pp/bmc/sensor.h>
#include <pp/bmc/ipmi_sdr.h>
#include <pp/bmc/topo_base_obj.h>
#include <pp/bmc/topo_factory.h>
#include <pp/bmc/tp_scan_sensdev.h>
#include <pp/bmc/debug.h>

#include "dummy_sensors.h"


/*
 * private structures
 ************************/
/*
 * dummy sensor's structure, they have a specific name only
 */
typedef struct {
    pp_tp_scan_sensdev_t base;
    int varreading;   // to get some changing value
    int vardirection; // direction of change
} dummy_sensor_t;


/*
 * static funktion prototypes
 ******************************/
static pp_tp_sensdev_t* voltage_dummy_create(const char* id_string);

//static char* dvs_to_string(pp_tp_sensdev_t* sensor);
static void  dvs_destroy(pp_tp_obj_t* sensor);
static ipmi_sdr_header_t* dvs_default_sdr(pp_tp_sensdev_t* s);
static void dvs_update_reading(pp_sensor_scannable_t *s);

/*
 * method implementations, public and private
 *************************************************/

pp_tp_obj_t* pp_sensor_dummy_ctor(const char* id, vector_t* args) {
    const char* fn = __FUNCTION__;
    int snum;
    pp_strstream_t err = PP_STRSTREAM_INITIALIZER;
    pp_tp_sensdev_t* o;
    
    if (pp_tp_arg_scanf(args, 0, &err, "d", &snum) != 1) {
	pp_bmc_log_error("%s: '%s' failed: %s (%s)",
		fn, id, strerror(errno), pp_strstream_buf(&err));
	o = NULL;
    } else if (snum > 0) {
	pp_bmc_log_error("%s: '%s' failed: invalid sensor number: %d",
		fn, id, snum);
	o = NULL;
    } else {
	o = voltage_dummy_create(id);
    }
    return (pp_tp_obj_t*)o;
}

static pp_tp_sensdev_t* voltage_dummy_create(const char* id) {
    dummy_sensor_t* ds = malloc(sizeof(dummy_sensor_t));
    pp_tp_scan_sensdev_init(&ds->base, PP_TP_SCAN_SENS_DEV, id,
			    dvs_destroy, dvs_default_sdr,
			    dvs_update_reading, NULL);
    ds->varreading = 10;
    ds->vardirection = 1;

    /* register for scanning  */
    pp_tp_scan_sensdev_register(&ds->base, 0);

    return (pp_tp_sensdev_t*)ds;
}

static void dvs_destroy(pp_tp_obj_t* sensor) {
    pp_tp_scan_sensdev_t* this = (pp_tp_scan_sensdev_t*)sensor;
    pp_tp_scan_sensdev_unregister(this);
    pp_tp_scan_sensdev_cleanup(this);
    free(sensor);
}

static ipmi_sdr_header_t* dvs_default_sdr(pp_tp_sensdev_t* s UNUSED) {
    ipmi_sdr_full_sensor_t* mysdr;
    mysdr = ipmi_sdr_full_part_create(IPMI_SENSOR_TYPE_VOLTAGE,
				      IPMI_EVENT_READING_TYPE_THRESHOLD,
				      IPMI_UNIT_TYPE_VOLTS,
				      IPMI_ANALOG_DATA_FORMAT_2_COMPL,
                                      PP_BMC_SDR_M_TOL_2_MTOL(4, 1),
                                      PP_BMC_SDR_B_ACCURACY_2_BACC(0, 0),
                                      0, -2,
			ipmi_sdr_max_by_form(IPMI_ANALOG_DATA_FORMAT_2_COMPL),
			ipmi_sdr_min_by_form(IPMI_ANALOG_DATA_FORMAT_2_COMPL));

    return (ipmi_sdr_header_t*)mysdr;
}

static void dvs_update_reading(pp_sensor_scannable_t* s) {
    dummy_sensor_t* this = PP_TP_SCANNABLE_2_OBJ_CAST(s, dummy_sensor_t);

    pp_tp_scan_sensdev_update_reading(&this->base,
				      0x53 + this->varreading - 10);
    
    this->varreading = this->varreading + this->vardirection;
    if (this->varreading >= 20) this->vardirection = -1;
    else if (this->varreading <= 0) this->vardirection = 1;
}

/*
static char* dvs_to_string(pp_tp_sensdev_t* sensor) {
    dummy_sensor_t* dvs = (dummy_sensor_t*)sensor;
    pp_strstream_reset(&pp_sensor_to_string_stream);
    pp_strappendf(&pp_sensor_to_string_stream,
		  "dummy voltage sensor");
    return pp_strstream_buf(&pp_sensor_to_string_stream);
}
*/

/**
 * This is a 
 *****************************************************************/
//pp_tp_sensdev_t* pp_sensor_chassis_dummy_create();
