/**
 * linear_fan_ctrl.c
 *
 * Configurable Linear fan controller for one temperature sensor
 * and several pwms.
 * 
 * (c) 2005 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 */

#ifndef _PP_BMC_TP_LINEAR_FAN_CTRL_H
#define _PP_BMC_TP_LINEAR_FAN_CTRL_H

#include <pp/bmc/tp_ctrl.h>

typedef struct {
    pp_tp_ctrl_t base;
    
    pp_tp_sensdev_t* temp_sensor;
    int a;
    int b;
    int c;
    int min;
    int max;
    vector_t * pwm_actors;   // vector of tp_pwm_act_t* 
    
    pp_tp_sensdev_subscriber_t temp_subscriber;

} pp_linear_fan_ctrl_t;

/* ppdoc
 * name:   Linear Fan Controller
 * tpname: LinearFanCtrl 
 * desc:   This objects implements a linear fan controller that creates
 * desc:   pwm duty cycles from temperatures with the following function:
 * desc:   f(x) = (a/b)*x + c (in %)
 * arg 0:  [OBJ(IPMI_SENS)] tempsens: temperature sensor
 * arg 1:  [INT] a:                   formula parameter 'a', see description
 * arg 2:  [INT] b:                   formula parameter 'b', see description
 * arg 3:  [INT] c:                   formula parameter 'c', see description
 * arg 4:  [INT] min_pwm:             minimum pwm value in %
 * arg 5:  [INT] max_pwm:             maximum pwm value in %
 * arg 6:  [OBJ(PWM_ACT)] pwm_act:    pwm actor to control
 * arg 7:  [...]                      (optional, repeatable) arg 6 may be repeated
 * arg 7:                             to add additional pwm actors to the controller
 * return: [OBJ(FAN_CTRL)]
 */
pp_tp_obj_t* pp_linear_fan_ctrl_ctor(const char* id, vector_t* args);

void pp_linear_fan_ctrl_dtor(pp_tp_obj_t* this);

/**
 * Initialize a linear fan control object. Sensors will be duplicated
 * internally. Control also takes ownership of pwm_actors vector but
 * duplicates the member objects itself.
 */
int pp_linear_fan_ctrl_init(pp_linear_fan_ctrl_t* this,
                        pp_tp_obj_type_t type, const char* id,
                        pp_tp_obj_dtor_func_t dtor,
                        pp_tp_sensdev_t* temp_sens,
                        int a, int b, int c, int min, int max, 
                        vector_t * pwm_actors);

void pp_linear_fan_ctrl_cleanup(pp_linear_fan_ctrl_t* this);

#endif
