/**
 * lm75_sensor.h
 *
 * roka@peppercon.de
 */

#ifndef __LM75_SENSOR_H
#define __LM75_SENSOR_H

#include <pp/vector.h>
#include <pp/bmc/topo_base_obj.h>

/* ppdoc
 * name:   LM75 temperature sensor
 * tpname: LM75
 * arg 0:  [OBJ(I2C_COM_DEV)] i2cdev: i2c device to be used
 * arg 1:  [INT] i2c_addr:            i2c slave address of this device
 * return: [OBJ(SENS_DEV)]
 */
pp_tp_obj_t* pp_sensor_lm75_ctor(const char* id, vector_t* args);

#define PP_SENSOR_LM75_MAX_SENSOR_NUM 10

#endif /* __LM75_SENSOR_H */
