/**
 * lm94.h
 *
 * implements the lm94 chip object
 * 
 * (c) 2006 Peppercon AG, 2006/03/24, rgue@peppercon.de
 */

#include <pp/base.h>
#include <pp/bmc/tp_i2c_chip.h>

typedef struct {
    /* chip superobject */
    pp_tp_i2c_chip_t base;

    unsigned char fan_pulse_per_revol[4];
} pp_tp_lm94_t;


/* ppdoc
 * name:   LM94 chip
 * tpname: LM94_chip
 * desc:   LM94 chip object, needed by LM94 sensors and pwms.
 * arg 0:  [OBJ(I2C_COM_DEV)] i2cdev: i2c device to be used
 * arg 1:  [INT] i2c_addr:            i2c slave address of this device
 * arg 2:  [OBJ(COND)] powercond:     power on condition (chip will be
 * arg 2:                             initialized if condition changes to on,
 * arg 2:                             sensors won't be read while cond is false)
 * return: [OBJ(I2C_CHIP)]
 */
pp_tp_obj_t* pp_lm94_ctor(const char* id, vector_t* args);
