/**
 * lm94_sensor.h
 *
 * implements the lm94 sensors
 * 
 * (c) 2006 Peppercon AG, 2006/03/24, rgue@peppercon.de
 */

#ifndef __LM94_SENSOR_H
#define __LM94_SENSOR_H

#include <pp/vector.h>
#include <pp/base.h>

#include <pp/bmc/topo_base_obj.h>
#include <pp/bmc/tp_i2c_chip.h>


/* ppdoc:
 * name:   LM94 sensor
 * tpname: LM94sens
 * desc:   LM94 sensor object, dissolves to different sensors depending
 * desc:   on the arguments. Relies on an LM94 chip object.
 * arg 0:  [OBJ(I2C_CHIP)] chip: i2c chip to use, must be an LM94 chip object
 * arg 1:  [INT] sensor_no:      sensor number within the chip, whereas:
 * arg 1:                         0: ad_in1
 * arg 1:                         1: ad_in2
 * arg 1:                         2: ad_in3 (+12V)
 * arg 1:                         3: ad_in4
 * arg 1:                         4: ad_in5
 * arg 1:                         5: ad_in6
 * arg 1:                         6: ad_in7 (CPU1 core)
 * arg 1:                         7: ad_in8 (CPU2 core)
 * arg 1:                         8: ad_in9 (+3.3V)
 * arg 1:                         9: ad_in10 (+5V)
 * arg 1:                        10: ad_in11
 * arg 1:                        11: ad_in12
 * arg 1:                        12: ad_in13
 * arg 1:                        13: ad_in14
 * arg 1:                        14: ad_in15 (-12V)
 * arg 1:                        15: tach1
 * arg 1:                        16: tach2
 * arg 1:                        17: tach3
 * arg 1:                        18: tach4
 * arg 1:                        19: cpu1_tempA
 * arg 1:                        20: cpu2_tempA
 * arg 1:                        21: cpu1_tempB
 * arg 1:                        22: cpu2_tempB
 * arg 2: [OBJ(COND)] scan_cond: (optional) scan_condition, sensor won't be
 * arg 2:                        read if condition is false
 * return: [OBJ(SENS_DEV)]
 */
pp_tp_obj_t* pp_lm94_sensor_ctor(const char* id, vector_t* args);

#define PP_SENSOR_LM94_MAX_SENSOR_NUM 22

#endif /* __LM94_SENSOR_H */
