/**
 * ltc4305_i2c_mux.h
 *
 * A concrete implementation for the LTC4305 2-Channel 2-Wire Bus Multiplexer
 * (used as I2C multiplexer)
 * (c) 2006 Peppercon AG, 08/15/2006, mkl@peppercon.de
 */

#ifndef __TP_PP_I2C_MUX_4305_H__
#define __TP_PP_I2C_MUX_4305_H__

#include <pp/vector.h>
#include <pp/bmc/tp_i2c_mux.h>

typedef struct pp_i2c_mux_ltc4305_s {
    pp_tp_i2c_mux_t base;
} pp_i2c_mux_ltc4305_t;

void pp_i2c_mux_ltc4305_init(pp_i2c_mux_ltc4305_t* d,
			     const char* id,
			     pp_tp_i2c_comdev_t* parent,
			     u_char i2caddr, 
			     u_char channel);

static inline void pp_i2c_mux_ltc4305_cleanup(pp_tp_obj_t* d) {
    pp_tp_i2c_mux_cleanup((pp_tp_i2c_mux_t*)d);
}

/* ppdoc
 * name:   I2C multiplexer LTC4305
 * tpname: I2CMux4305
 * desc:   LTC4305 i2c multiplexer, can be used to address one
 * desc:   branch of the 4305 as i2c communication device (I2C_DEV).
 * arg 0:  [OBJ(I2C_COM_DEV)] i2cdev: i2c master device the mux is connected to
 * arg 1:  [INT] i2c_addr:            i2c slave address of this mux
 * arg 2:  [INT] channel:             downstream channel number of this mux
 * return: [OBJ(I2C_MUX)]
 */
pp_tp_obj_t* pp_i2c_mux_ltc4305_ctor (const char* id, vector_t* args);

/**
 * Destroy method
 */
void pp_i2c_mux_ltc4305_dtor (pp_tp_obj_t* d);

#endif
