/**
 * max1037_adc_sensor.h
 *
 * MAX1037 4-Channel ADC
 * 
 * (c) 2006 Peppercon AG, mkl@peppecon.de
 */

#ifndef __MAX1037_ADC_SENSOR_H
#define __MAX1037_ADC_SENSOR_H

#include <pp/bmc/topo_base_obj.h>

/* ppdoc: 
 * name:   MAX1037 ADC
 * tpname: MAX1037ADC
 * desc:   MAX1037 4-Channel ADC sensor chip.
 * arg 0:  [OBJ(I2C_COM_DEV)] i2cdev:  i2c device the adc is connected to
 * arg 1:  [INT] i2caddr:              i2c slave address of this adc
 * arg 2:  [INT] sensor_ch:            sensor channel
 * arg 2:                              0-3: current sensor
 * arg 3:  [OBJ(COND)] scan_cond:      (optional) power condition. Sensor
 * arg 4:                              won't be scanned if condition is false
 * return: [OBJ(SENS_DEV)]
 */
pp_tp_obj_t* pp_sensor_max1037_adc_ctor(const char* id, vector_t* args);

#endif /* __MAX1037_ADC_SENSOR_H */
