/**
 * msi_smx.c
 * 
 * MSI specific MUX switch
 * works in all MSI boards that have the MSI-connector
 * 
 * (c) 2005 Peppercon AG, 2005/05/30, thomas@peppercon.de
 */

#include <pp/base.h>
#include <lara.h>
#include <pp/bmc/debug.h>
#include <pp/bmc/topo_factory.h>
#include <pp/bmc/tp_gpio_dev.h>
#include <pp/bmc/tp_smx_act.h>
#include "msi_smx.h"

typedef struct msi_smx_s {
    pp_tp_smx_act_t base;
    pp_tp_gpio_dev_t* gpio_dev;
} msi_smx_t;

#define BUSSWITCH_GPIO	0

static const char* cname = "[MsiSmx]";

static int msi_smx_switch_host_chassis(pp_tp_smx_act_t* this) {
    msi_smx_t* t = (msi_smx_t*)this;
    pp_bmc_log_debug("%s switching S-Mux to host-chassis", cname);
    /* TODO(miba) create a ppc gpio device and use this */
    pp_gpio_set(PP_GPIO_DEV_IBM, 0, PP_IBM_GPIO_MASK(1), 0); // straight BMC TX/RX lines
    pp_gpio_set(PP_GPIO_DEV_IBM, PP_IBM_GPIO_MASK(9), 0, 0); // chassis enable
    pp_tp_gpio_dev_set_gpio(t->gpio_dev, BUSSWITCH_GPIO, 0); // bus switch enable
    return PP_SUC;
}

static int msi_smx_switch_bmc_chassis(pp_tp_smx_act_t* this) {
    msi_smx_t* t = (msi_smx_t*)this;
    pp_bmc_log_debug("%s switching S-Mux to bmc-chassis", cname);
    pp_gpio_set(PP_GPIO_DEV_IBM, 0, PP_IBM_GPIO_MASK(1), 0); // straight BMC TX/RX lines
    pp_gpio_set(PP_GPIO_DEV_IBM, PP_IBM_GPIO_MASK(9), 0, 0); // chassis enable
    pp_tp_gpio_dev_set_gpio(t->gpio_dev, BUSSWITCH_GPIO, 1); // bus switch disable
    return PP_SUC;
}

static int msi_smx_switch_host_bmc(pp_tp_smx_act_t* this) {
    msi_smx_t* t = (msi_smx_t*)this;
    pp_bmc_log_debug("%s switching S-Mux to host-bmc", cname);
    pp_gpio_set(PP_GPIO_DEV_IBM, PP_IBM_GPIO_MASK(1), 0, 0); // cross BMC TX/RX lines
    pp_gpio_set(PP_GPIO_DEV_IBM, 0, PP_IBM_GPIO_MASK(9), 0); // chassis disable
    pp_tp_gpio_dev_set_gpio(t->gpio_dev, BUSSWITCH_GPIO, 0); // bus switch enable
    return PP_SUC;
}

static void msi_smx_dtor(pp_tp_obj_t* o) {
    if (o != NULL) {
	assert(PP_TP_OBJ_IS_TYPE(PP_TP_SMX_ACT, o));
	msi_smx_t* this = (msi_smx_t*)o;
	pp_tp_gpio_dev_release(this->gpio_dev);
	pp_tp_smx_act_cleanup(&this->base);
	free(this);
    }
}

pp_tp_obj_t* pp_msi_smx_ctor (const char* id, vector_t* args) {
    pp_strstream_t err = PP_STRSTREAM_INITIALIZER;
    pp_tp_gpio_dev_t* gpio_dev;
    msi_smx_t* this = NULL;

    if (pp_tp_arg_scanf(args, 0, &err, "o<g>", &gpio_dev) != 1) {
	pp_bmc_log_error("%s (%s) failed: %s", cname, id,
			 pp_strstream_buf(&err));
    } else {
	this = malloc(sizeof(msi_smx_t));
	pp_tp_smx_act_init(&this->base, PP_TP_SMX_ACT, id, msi_smx_dtor,
			   msi_smx_switch_host_chassis,
			   msi_smx_switch_bmc_chassis,
			   msi_smx_switch_host_bmc);
	this->gpio_dev = pp_tp_gpio_dev_duplicate(gpio_dev);

	pp_tp_gpio_dev_init_gpio(this->gpio_dev, (1 << BUSSWITCH_GPIO));
    }
    pp_strstream_free(&err);
    return (pp_tp_obj_t*)this;
}
