/**
 * pp_pca9556_gpio_dev.h
 *
 * Device driver class for the Philips PCA9556 I2C GPIO Extender
 *                 and for the Philips PCA9554 I2C GPIO Extender
 *                 (PCA9554 is logically identical to the PCA9556,
 *                 but works with different voltage levels)
 * 
 * (c) 2005 Peppercon AG, Michael Baumann <miba@peppercon.de>
 */

 
#ifndef __PP_BMC_PCA9556_GPIO_DEVICE_H__
#define __PP_BMC_PCA9556_GPIO_DEVICE_H__

#include <pp/bmc/tp_i2c_comdev.h>
#include <pp/bmc/tp_gpio_dev.h>

#include "pca955x_gpio_dev.h"

/**
 * concrete device for PCA9556 extender
 */
typedef struct pp_pca9556_gpio_dev_s {
    pp_pca955x_gpio_dev_t base;
} pp_pca9556_gpio_dev_t;


/**
 * device initializer
 * @returns PP_ERR if the initialization failed
 */
int pp_pca9556_gpio_dev_init(pp_pca9556_gpio_dev_t* d, const char* id,
			     pp_tp_i2c_comdev_t* i2cdev,
			     u_char i2caddr, pp_tp_cond_t* pres_cond);

/* ppdoc
 * name:   Philips PCA 9556 i2c gpio extender
 * tpname: PCA9556Gpio
 * arg 0:  [OBJ(I2C_COM_DEV)] i2cdev: i2c device the extender is connected to
 * arg 1:  [INT] i2c_addr:            i2c slave address of this extender
 * arg 2:  [OBJ(COND)] presence:      (optional) presence (power on) condition
 * return: [OBJ(GPIO_DEV)]
 */
pp_tp_obj_t* pp_pca9556_gpio_dev_ctor(const char* id, vector_t* args);

#endif

