/**
 * pp_pca955x_gpio_dev.h
 *
 * Device driver base class for the Philips PCA955x family
 * of I2C GPIO Extenders
 * 
 * (c) 2005 Peppercon AG, Michael Baumann <miba@peppercon.de>
 */
 
#ifndef __PP_BMC_PCA955X_GPIO_DEVICE_H__
#define __PP_BMC_PCA955X_GPIO_DEVICE_H__

#include <pp/bmc/tp_i2c_comdev.h>
#include <pp/bmc/tp_gpio_dev.h>
#include <pp/bmc/tp_cond.h>

/**
 * abstract device for a PCA955x extender
 */
typedef struct pp_pca955x_gpio_dev_s {
    pp_tp_gpio_dev_t base;

    pp_tp_i2c_comdev_t *i2cdev;
    u_char i2caddr;

    pp_tp_cond_t* pres_cond;

    int value;
    
    int to_hndl;

    u_long output_driven_state; /* saved output state (driven) */
    u_long output_tri_state;    /* saved output state (tristate) */
    u_long output_valid_mask;   /* output state validity */
    pp_tp_sensdev_subscriber_t pres_cond_subs;

    int (*get_val)(struct pp_pca955x_gpio_dev_s *d);
    int (*set_reg)(struct pp_pca955x_gpio_dev_s *d, u_char reg, u_long mask,
		   u_long val);
} pp_pca955x_gpio_dev_t;

/* common register types for all 955x devices */
#define REG_INPUT	0
#define REG_OUTPUT	1
#define REG_POL_INV	2
#define REG_CONFIG	3

/**
 * device initializer
 * @returns PP_ERR if the initialization failed
 */
int pp_pca955x_gpio_dev_init(pp_pca955x_gpio_dev_t* d,
			     pp_tp_obj_type_t type, const char* id,
			     pp_tp_i2c_comdev_t* i2cdev,
			     u_char i2caddr,
			     u_long valid_mask,
			     int (*get_val)(pp_pca955x_gpio_dev_t *d),
			     int (*set_reg)(pp_pca955x_gpio_dev_t *d, u_char reg,
					    u_long mask, u_long val),
			     pp_tp_cond_t* pres_cond);

void pp_pca955x_gpio_dev_cleanup(pp_tp_obj_t* d);

#endif
