/**
 * pp_gpio_disc_sens.h
 *
 * This is a gpio sensor that produces IPMI conformant readings
 * for discrete sensors instead of simple asserted/deasserted
 * readings. In contrast to generic gpio sensors, this sensor
 * is designed to be exported through an IPMI_SENS.
 *
 * (c) 2005 Peppercon AG, Michael Baumann <miba@peppercon.de>
 */

#ifndef _PP_BMC_GPIO_DISC_SENS_H
#define _PP_BMC_GPIO_DISC_SENS_H

#include <pp/bmc/tp_sens_subscriber.h>
#include <pp/bmc/tp_gpio_sens.h>
#include <pp/bmc/tp_sensdev.h>
#include <pp/bmc/topo_factory.h>

/**
 * concrete gpio signal input sensor
 */
typedef struct {
    pp_tp_sensdev_t base;

    pp_tp_gpio_sens_t* gpio_sens;
    pp_tp_sensdev_subscriber_t gpio_subscriber;
    
    u_short state_asserted;
    u_short state_deasserted;

    u_char sens_type;
    u_char reading_type;
} pp_gpio_disc_sens_t;

/* ppdoc
 * name:   Configurable discrete gpio sensor
 * tpname: GpioDiscSens
 * desc:   This is a configurable discrete gpio sensor that can be exported
 * desc:   in arbitrary IPMI sensors. 
 * desc:   In contrast to regular gpio sensors, it can not only return 0 and 1
 * desc:   but configurable readings. It needs a regular gpio sensor as data source.
 * arg 0:  [OBJ(GPIO_SENS)] gpio:   the gpio sensor to use as data source
 * arg 1:  [INT] stype:             sensor type (see IPMI spec tab 42-3)
 * arg 2:  [INT] rtype:             reading type (see IPMI spec tab 42-2)
 * arg 3:  [INT] ent_id:            entity id (see IPMI spec tab 43-13)
 * arg 4:  [INT] ent_instance:      entity instance
 * arg 5:  [INT] reading_ass:       reading when asserted (see IPMI spec tab 42-2, 42-3)
 * arg 6:  [INT] reading_dea:       reading when deasserted (see IPMI spec tab 42-2, 42-3)
 * return: [OBJ(SENS_DEV)]
 */
pp_tp_obj_t* pp_gpio_disc_sens_ctor(const char* id, vector_t* args);

void pp_gpio_disc_sens_dtor(pp_tp_obj_t* this);

int pp_gpio_disc_sens_init(pp_gpio_disc_sens_t* this, pp_tp_obj_type_t type,
			   const char* id, pp_tp_obj_dtor_func_t dtor,
			   pp_tp_sensdev_default_sdr_func_t default_sdr,
			   pp_tp_gpio_sens_t* gpio_sens,
			   u_char sens_type, u_char reading_type,
			   u_short state_asserted, u_short state_deasserted);

void pp_gpio_disc_sens_cleanup(pp_gpio_disc_sens_t* this);

static inline
pp_gpio_disc_sens_t* pp_gpio_disc_sens_duplicate(pp_gpio_disc_sens_t* this)
{
    return (pp_gpio_disc_sens_t*)pp_tp_obj_duplicate((pp_tp_obj_t*)this);
}

static inline void
pp_gpio_disc_sens_release(pp_gpio_disc_sens_t* this)
{
    pp_tp_obj_release((pp_tp_obj_t*)this);
}

#endif /* _PP_BMC_GPIO_DISC_SENS_H */
