/**
 * pp_tach_sens.h
 *
 * Scannable Tacho Sensor reads values from tacho device.
 * Triggered either through scanner thread or an instance
 * of MuxedScanner.
 * 
 * (c) 2006 Peppercon AG, mkl@peppercon.de
 */
#ifndef __PP_BMC_PP_TACH_SENS_H__
#define __PP_BMC_PP_TACH_SENS_H__

#include <pp/bmc/tp_scan_sensdev.h>
#include <pp/bmc/tp_gpio_multi_act.h>

/* ppdoc
 * name:   Muxed sensor
 * tpname: MuxedSens
 * desc:   A sensor that reads values from tacho devices.
 * desc:   Triggered either through scanner thread or an
 * desc:   instance of MuxedScanner.
 * arg 0:  [INT] tacho_no:         Number of internal tacho sensor (0-7)
 * arg 1:  [INT] puls_p_rev:       pulses per revolution
 * arg 2:  [OBJ(COND)] scan_cond:  (optional) sensor scan condition. Sensor will
 * arg 2:                          not produce readings while condition is false.
 * arg 3:  [OBJ(GPIO_MULTI_ACT)] mux: (optional)This mux switches between
 * arg 3:                          banks and trigger the update function. If omitted update
 * arg 3:                          function will be called through scanner thread.
 * arg 4:  [INT(COND)] bank: (optional) Bank Number of this tacho device
 * return: [OBJ(SENS_DEV)]
 */
pp_tp_obj_t* pp_tach_sens_ctor(const char* id, vector_t* args);

#endif /* __PP_BMC_PP_TACH_SENS_H__ */
