/**
 * rc_rs485_dev.h
 *
 * This implements a special communication object for
 * RPC RS485 protocoll
 *
 * (c) 2006 Peppercon AG, 2006/09/05 tbr@raritan.com
 */

#ifndef __PP_BMC_RC_RS485_DEV_H__
#define __PP_BMC_RC_RS485_DEV_H__

#include <pp/vector.h>
#include <pp/bmc/topo_base_obj.h>

/*
 * ppdoc
 * name: RPC RS485 Communication Device 
 * tpname: RS485
 * desc: RS485 Bus communication protocoll
 * arg 0: [STRING] rs485_dev_name: device name of uart to use for
 *                                 communication
 * arg 1: [OBJ<GPIOACT>] rs485_dir: gpio actor for controlling 
 *                                  direction of rs485 driver
 */
pp_tp_obj_t* pp_rc_rs485_dev_ctor(const char* id, vector_t* args);


#endif /* __PP_BMC_RC_RS485_DEV_H__ */
