/**
 * w83792d.h
 *
 * implements the w83792d chip object
 * 
 * (c) 2006 Peppercon AG, 2006/03/24, rgue@peppercon.de
 */

#ifndef __PP_SENSOR_W83792D_H__
#define __PP_SENSOR_W83792D_H__

#include <pp/bmc/topo_base_obj.h>
#include <pp/bmc/tp_i2c_chip.h>

typedef struct pp_tp_w83792d_chip_s {
    pp_tp_i2c_chip_t base;
    unsigned char pwm_pre_scale;
} pp_tp_w83792d_chip_t;


/* ppdoc
 * name:   W83792d chip
 * tpname: W83792D
 * desc:   Common object for all w83792 sensors, pwms and gpios.
 * arg 0:  [OBJ(I2C_COM_DEV)] i2cdev: i2c device to be used
 * arg 1:  [INT] i2c_addr:            i2c slave address of this device
 * arg 2:  [OBJ(COND)] powercond:     power on condition (chip will be
 * arg 2:                             initialized if condition changes to on,
 * arg 2:                             sensors won't be read while cond is false)
 * arg 3:  [INT] gpio_mask:           GPIO mask, 12 bit, 1 enables according GPIO
 * arg 4:  [INT] gpio_dir:            GPIO in/out mask, 12 bit, 1 marks GPIO as output
 * arg 5:  [INT] pwm_prescaler:       PWM Pre Scale Register, 8bit as per Spec,
 * arg 5:                             currently identical for all 5 PWMs,
 * arg 5:                             will be written to 0x80, 0x82, 0x93, 0xA0, 0xA1
 * return: [OBJ(I2C_CHIP)]
 */
pp_tp_obj_t* pp_sensor_w83792d_ctor(const char* id, vector_t* args);

#define W83792D_MODEL_STRING "w83792d"

//#define W83792D_PWM_MAX_NUMBER 5

#endif /* __PP_SENSOR_W83792D_H__ */
