/**
 * tp_static_cond.h
 *
 * The simplest real condition object
 * 
 * (c) 2005 Peppercon AG, 23/06/2005, tbr@peppecon.de
 */

#ifndef _PP_BMC_TP_STATIC_COND_H
#define _PP_BMC_TP_STATIC_COND_H

#include <pp/bmc/tp_cond.h>

typedef struct pp_tp_static_cond_s pp_tp_static_cond_t;

/* ppdoc
 * name:   Static condition pp_tp_static_cond_ctor
 * tpname: StaticCond
 * desc:   A simple static condition. The value of this condition can only
 * desc:   be changed by bmc internal code.
 * arg 0:  [BOOL] value: intial condition value
 * return: [OBJ(STATIC_COND)]
 */
pp_tp_obj_t* pp_tp_static_cond_ctor(const char* id, vector_t* args);

void pp_tp_static_cond_dtor(pp_tp_obj_t* this);

int pp_tp_static_cond_init(pp_tp_static_cond_t * this, pp_tp_obj_type_t type, const char * id,
			   pp_tp_obj_dtor_func_t dtor, int init_value);

void pp_tp_static_cond_cleanup(pp_tp_static_cond_t* this);

void pp_bmc_tp_static_cond_set(pp_tp_static_cond_t* this, int value);

#endif /* _PP_BMC_TP_STATIC_COND_H */
