/**
 * topo_ctors.h
 *
 * This file defines the preefined Topology Descriptor lists.
 * 
 * Any code that plugs into the topology framework must be
 * registered here (unless we got a dymanic method to do that)!
 * 
 * (c) 2005 Peppercon AG, 3/9/2005, tbr@peppecon.de
 */

#include "topo_parser_impl.h"
#include "topo_ctors.h"
#include <pp/bmc/topo_base_obj.h>

#include <pp/bmc/tp_ipmi_sens.h>
#include <pp/bmc/tp_muxed_scanner.h>
#include <pp/bmc/tp_gpio_sens.h>
#include <pp/bmc/tp_gpio_multi_sens.h>
#include <pp/bmc/tp_gpio_bulk_sens.h>
#include <pp/bmc/tp_gpio_act.h>
#include <pp/bmc/tp_gpio_multi_act.h>
#include <pp/bmc/tp_gpio_loop.h>
#include <pp/bmc/tp_sdr.h>
#include <pp/bmc/tp_static_cond.h>
#include <pp/bmc/tp_delayed_cond.h>
#include <pp/bmc/tp_i2c_alive_cond.h>
#include <pp/bmc/tp_sens_has_value_cond.h>
#include <pp/bmc/tp_and_cond.h>
#include <pp/bmc/tp_acpi_power_state_opma.h>
#include <pp/bmc/tp_acpi_power_state_gpio.h>
#include <pp/bmc/tp_event_collect_ctrl.h>
#include <pp/bmc/tp_event_collect_pwm_ctrl.h>
#include "drivers/dummy_sensors.h"
#include "drivers/pp_i2c_dev.h"
#include "drivers/pp_fpga_gpio_dev.h"
#include "drivers/pp_tach_sens.h"
#include "drivers/pp_fpga_pwm_dev.h"
#include "drivers/pp_gpio_disc_sens.h"
#include "drivers/pp_powersupply_sens.h"
#include "drivers/pca9555_gpio_dev.h"
#include "drivers/pca9556_gpio_dev.h"
#include "drivers/max7312_gpio_dev.h"
#include "drivers/pca9542_i2c_mux.h"
#include "drivers/pca9544_i2c_mux.h"
#include "drivers/pca9548_i2c_mux.h"
#include "drivers/ltc4305_i2c_mux.h"
#include "drivers/ltc4306_i2c_mux.h"
#include "drivers/adm1031_sensor.h"
#include "drivers/adm1029.h"
#include "drivers/adm1026.h"
#include "drivers/adm1024.h"
#include "drivers/ads7830_sensor.h"
#include "drivers/w83791d.h"
#include "drivers/w83791d_sensor.h"
#include "drivers/w83791d_gpio.h"
#include "drivers/w83791d_pwm.h"
#include "drivers/lm75_sensor.h"
#include "drivers/adt7463_chip.h"
#include "drivers/adt7463_sensor.h"
#include "drivers/adt7463_pwm.h"
#include "drivers/max6695_sensor.h"
#include "drivers/max6649_sensor.h"
#include "drivers/max1037_adc_sensor.h"
#include "drivers/max6681_sensor.h"
#include "drivers/msi_smx.h"
#include "drivers/msi_fan_ctrl.h"
#include "drivers/opma_smx.h"
#include "drivers/smi_smx.h"
#include "drivers/warthog_fan_ctrl.h"
#include "drivers/cheyenne_fan_ctrl.h"
#include "drivers/linear_fan_ctrl.h"
#include "drivers/adc_kira_sensor.h"
#include "drivers/w83792d.h"
#include "drivers/w83792d_sensor.h"
#include "drivers/w83792d_clr_intrusion.h"
#include "drivers/lm94.h"
#include "drivers/lm94_sensor.h"
#include "drivers/w83793g.h"
#include "drivers/w83793g_sensor.h"
#include "drivers/w83793g_clr_intrusion.h"
#include "drivers/tmp101.h"
#include "drivers/dummy_smx.h"

#include "drivers/rc_rs485_dev.h"
#include "drivers/rc_cy8c26.h"
#include "drivers/rpc_cbk_sensor.h"
#include "drivers/rpc_pwr_sens.h"
#include "drivers/rpc_beep_ctrl.h"
#include "drivers/rpc_disp_ctrl.h"
#include <pp/bmc/rpc_olled_ctrl.h>



pp_tp_obj_ctor_def_t pp_tp_ctors_basic[] = {
    /* chips */
    { "I2CChip",                pp_tp_i2c_chip_ctor },
    { "ADM1029",              	pp_sensor_adm1029_ctor },
    { "ADM1026",              	pp_sensor_adm1026_ctor },
    { "ADM1024",              	pp_sensor_adm1024_ctor },
    { "ADT7463",		pp_adt7463_chip_ctor },
    { "W83791D",              	pp_sensor_w83791d_ctor },
    { "W83792D",              	pp_sensor_w83792d_ctor },
    { "LM94",              	pp_lm94_ctor },
    { "W83793G",              	pp_sensor_w83793g_ctor },
#ifdef PP_FEAT_PDU
    { "RCCY8C26",               pp_rc_cy8c26_chip_ctor },
#endif /* PP_FEAT_PDU */
	
    /* devices */
    { "I2C",                    pp_i2c_dev_ctor },
#ifdef PP_FEAT_PDU
    { "RS485",                  pp_rc_rs485_dev_ctor }, 
#endif /* PP_FEAT_PDU */
    { "I2CMux9542",		pp_i2c_mux_pca9542_ctor },
    { "I2CMux9544",		pp_i2c_mux_pca9544_ctor },
    { "I2CMux9548",		pp_i2c_mux_pca9548_ctor },
    { "I2CMux4305",		pp_i2c_mux_ltc4305_ctor },
    { "I2CMux4306",		pp_i2c_mux_ltc4306_ctor },
    { "FpgaGpio",		pp_fpga_gpio_dev_ctor },
    { "PCA9554Gpio",		pp_pca9556_gpio_dev_ctor }, //alias for 9556
    { "PCA9555Gpio",		pp_pca9555_gpio_dev_ctor },
    { "PCA9556Gpio",		pp_pca9556_gpio_dev_ctor },
    { "MAX7312Gpio",		pp_max7312_gpio_dev_ctor },
    { "ADM1029Gpio",            pp_sensor_adm1029_gpio_ctor },
    { "W83791DGpio",            pp_sensor_w83791d_gpio_ctor },
#ifdef PP_FEAT_PDU
    { "RCCY8C26Gpio",           pp_rc_cy8c26_gpio_ctor },
#endif /* PP_FEAT_PDU */
    
    /* sensors */
    { "ISens",			pp_tp_ipmi_sens_ctor },
    { "ISensFullSDR",		pp_tp_ipmi_sens_full_sdr_ctor },
    { "ISensCompactSDR",	pp_tp_ipmi_sens_compact_sdr_ctor },
    { "DummySens",		pp_sensor_dummy_ctor },
    { "GpioSens",		pp_tp_gpio_sens_ctor },
    { "TachSens",		pp_tach_sens_ctor },    
    { "GpioMultiSens",		pp_tp_gpio_multi_sens_ctor },
    { "GpioBulkSens",           pp_tp_gpio_bulk_sens_ctor },
    { "GpioDiscSens",		pp_gpio_disc_sens_ctor },
    { "PowersupplySens",	pp_powersupply_sens_ctor },
    { "AcpiPowerStateOpma",	pp_tp_acpi_power_state_opma_ctor },
    { "AcpiPowerStateGpio",	pp_tp_acpi_power_state_gpio_ctor },
    { "ADT7463sens",            pp_adt7463_sensor_ctor },
    { "ADM1031",		pp_sensor_adm1031_ctor },
    { "ADS7830",		pp_sensor_ads7830_ctor },
    { "LM75",			pp_sensor_lm75_ctor },
    { "MAX6695",		pp_sensor_max6695_ctor },
    { "MAX6649",		pp_sensor_max6649_ctor },
    { "MAX1037ADC",		pp_sensor_max1037_adc_ctor },
    { "MAX6681",		pp_sensor_max6681_ctor },
    { "W83791DSens",		pp_sensor_w83791d_sens_ctor },
    { "ADM1029Sens",            pp_sensor_adm1029_sens_ctor },
    { "ADM1026Sens",            pp_sensor_adm1026_sens_ctor },
    { "ADM1024Sens",            pp_sensor_adm1024_sens_ctor },
    { "ADCKIRASens",            pp_sensor_adc_kira_ctor },
    { "W83792DSens",		pp_sensor_w83792d_sens_ctor },
    { "LM94Sens",		pp_lm94_sensor_ctor },
    { "TMP101Sens",             pp_tmp101_sens_ctor },
    { "W83793GSens",		pp_sensor_w83793g_sens_ctor },
#ifdef PP_FEAT_PDU
    { "RCCY8C26Sens",		pp_rc_cy8c26_sens_ctor },
    { "RPCCurrSens",		pp_rpc_curr_sens_ctor },    
    { "MaxCurrSens",		pp_rpc_max_curr_sens_ctor },    
    { "AptPowerSens",		pp_rpc_apt_pwr_sens_ctor },
    { "RMSPowerSens",		pp_rpc_rms_pwr_sens_ctor },
    { "RPCPwrSens",		pp_rpc_pwr_sens_ctor },        
    { "MaxPowerSens",		pp_rpc_max_pwr_sens_ctor },    
    { "CBrkSens",		pp_rpc_cbk_sens_ctor },
#endif /* PP_FEAT_PDU */

    /* Conditions (these are sensors too!) */
    { "StaticCond",		pp_tp_static_cond_ctor },
    { "DelayedCond",            pp_tp_delayed_cond_ctor },
    { "SensHasValueCond",	pp_tp_sens_has_value_cond_ctor },
    { "I2CAliveCond",           pp_tp_i2c_alive_cond_ctor },
    { "AndCond",                pp_tp_and_cond_ctor },

    /* actors */
    { "GpioAct",		pp_tp_gpio_act_ctor },
    { "GpioMultiAct",           pp_tp_gpio_multi_act_ctor },
    { "FpgaPwm",		pp_fpga_pwm_dev_ctor },
    { "ADT7463pwm",             pp_adt7463_pwm_ctor },
    { "ADM1029PwmAct",          pp_sensor_adm1029_pwm_ctor },
    { "W83791DPwmAct",          pp_sensor_w83791d_pwm_ctor },
    { "W83792DClrIntrusion",	pp_sensor_w83792d_clr_intrusion_ctor },
    { "W83793GClrIntrusion",	pp_sensor_w83793g_clr_intrusion_ctor },
    { "DummySmx",               pp_dummy_smx_ctor },
#ifdef LARA_KIMMSI
    { "MsiSmxAct",		pp_msi_smx_ctor },
    { "MsiFanControl",          pp_msi_fan_ctrl_ctor },
#endif
#ifdef PP_FEAT_OPMA_HW
    { "OpmaSmxAct",             pp_opma_smx_ctor },
#endif
#ifdef PRODUCT_SMIDC
    { "SupermicroSmxAct",       pp_smi_smx_ctor },
#endif
#ifdef PP_FEAT_PDU
    { "RPCDispAct",	        pp_rpc_disp_act_ctor },
#endif /* PP_FEAT_PDU */

    /* controllers */
    { "GpioLoopCtrl",		pp_tp_gpio_loop_ctor},
    { "EventCollectCtrl",	pp_tp_event_collect_ctrl_ctor },
    { "EventCollectPwmCtrl",	pp_tp_event_collect_pwm_ctrl_ctor },
    { "WarthogFanCtrl",		pp_warthog_fan_ctrl_ctor },
    { "CheyenneFanCtrl",	pp_cheyenne_fan_ctrl_ctor },
    { "LinearFanCtrl",          pp_linear_fan_ctrl_ctor },
    { "MuxedScanner",           pp_tp_muxed_scanner_ctor },    
#ifdef PP_FEAT_PDU
    { "RPCBeepCtrl",            pp_rpc_beep_ctrl_ctor },
    { "RPCOllCtrl",             pp_rpc_olled_ctrl_ctor },
    { "RPCDispCtrl",            pp_rpc_disp_ctrl_ctor },
#endif /* PP_FEAT_PDU */

    /* SDR configs */
    { "ThreshSDR",		pp_tp_thresh_sdr_ctor },
    { "DiscSDR",		pp_tp_disc_sdr_ctor },
};

int pp_tp_ctors_basic_sz = sizeof(pp_tp_ctors_basic) / sizeof(pp_tp_obj_ctor_def_t);
