/**
 * tp_cond.c
 *
 * Abstract condition object
 * and simplest real condition object
 * 
 * (c) 2005 Peppercon AG, 23/06/2005, tbr@peppecon.de
 */

#include <pp/bmc/tp_cond.h>

int pp_tp_cond_init(pp_tp_cond_t* this, pp_tp_obj_type_t type, const char* id,
		    pp_tp_obj_dtor_func_t dtor) {
    MUTEX_CREATE_RECURSIVE(&this->mtx);
    return pp_tp_sensdev_init(&this->base, type, id, dtor, NULL);
}

void pp_tp_cond_lock(pp_tp_cond_t* this) {
    MUTEX_LOCK(&this->mtx);
}

void pp_tp_cond_unlock(pp_tp_cond_t* this) {
    MUTEX_UNLOCK(&this->mtx);
}

void pp_tp_cond_set_reading(pp_tp_cond_t* this, int reading) {
    MUTEX_LOCK(&this->mtx);
    if (this->base.reading != reading) {
	this->base.reading = reading;
	pp_tp_cond_notify_subscribers(this, reading);
    }
    MUTEX_UNLOCK(&this->mtx);
}

int pp_tp_cond_get_reading(pp_tp_cond_t* this) {
    int reading;
    MUTEX_LOCK(&this->mtx);
    reading = this->base.reading;
    MUTEX_UNLOCK(&this->mtx);
    return reading;
}

int pp_bmc_tp_cond_is_true(pp_tp_cond_t* this) {
    return (pp_tp_cond_get_reading(this) > 0);
}
