/**
 * tp_static_cond.c
 *
 * static condition object
 * 
 * (c) 2005 Peppercon AG, 23/06/2005, tbr@peppecon.de
 */

#include <pp/bmc/debug.h>
#include <pp/bmc/topo_factory.h>
#include <pp/bmc/tp_static_cond.h>
#include "sensor_scanner.h"

struct pp_tp_static_cond_s {
    pp_tp_cond_t base;
    int init_reading;
    pp_sensor_startable_t startable;
};

static void static_cond_start(pp_sensor_startable_t* s) {
    pp_tp_static_cond_t* this =
	PP_TP_INTF_2_OBJ_CAST(s, pp_tp_static_cond_t, startable);
    pp_bmc_tp_static_cond_set(this, this->init_reading);
}

/*
 * see header for docu
 */
pp_tp_obj_t*
pp_tp_static_cond_ctor(const char* id, vector_t* args)
{
    const char* errmsg = "[StaticCond] %s: '%s' failed (%s)";
    pp_strstream_t err = PP_STRSTREAM_INITIALIZER;
    pp_tp_static_cond_t* static_cond = NULL;
    int init_val;

    if (pp_tp_arg_scanf(args, 0, &err, "b", &init_val) != 1) {
	pp_bmc_log_error(errmsg, ___F, id, pp_strstream_buf(&err));
    } else {
	static_cond = calloc(1, sizeof(pp_tp_static_cond_t));
	if (PP_FAILED(pp_tp_static_cond_init(static_cond, PP_TP_STATIC_COND,
					     id, pp_tp_static_cond_dtor,
					     init_val))) {
	    pp_bmc_log_error(errmsg, ___F, id, "init");
	    free(static_cond);
	    static_cond = NULL;
	}
    }
    pp_strstream_free(&err);
    return (pp_tp_obj_t*)static_cond;
}

void
pp_tp_static_cond_dtor(pp_tp_obj_t* this)
{
    assert(this != NULL);
    pp_tp_static_cond_cleanup((pp_tp_static_cond_t*)this);
    free(this);
}

int
pp_tp_static_cond_init(pp_tp_static_cond_t * this, pp_tp_obj_type_t type,
		       const char * id, pp_tp_obj_dtor_func_t dtor,
		       int init_value)
{
    int ret = pp_tp_cond_init(&this->base, type, id, dtor);
    this->init_reading = init_value;
    this->startable.start = static_cond_start;
    pp_sensor_scanner_add_startable(&this->startable);
    return ret;
}
 
void
pp_tp_static_cond_cleanup(pp_tp_static_cond_t* this)
{
    pp_sensor_scanner_remove_startable(&this->startable);
    pp_tp_cond_cleanup(&this->base);
}

void
pp_bmc_tp_static_cond_set(pp_tp_static_cond_t* this, int value)
{
    int new_value = value > 0 ? 1 : 0;
    pp_tp_cond_set_reading(&this->base, new_value);
}
