/**
 * smi_bt_adapter.c
 *
 * (c) 2004 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 *
 * Uses the bmccore-msgrouter and the lpc.o Kernelmodule
 * to connect the bmccore to the host system interface.
 *
 * Please load the lpc.o module before initializing this adapter.
 *
 * Please create a character device /dev/lpc before initializing.
 * The major number is 246, the minor numer is 0.
 */

#include <pp/base.h>
#include <pp/cfg.h>
#include <pp/xdefs.h>
#include <pp/bmc/debug.h>
#include <pp/bmc/bmc_config.h>
#include <pp/bmc/smi_adapter.h>

#include "smi_kcs_adapter.h"
#include "smi_bt_adapter.h"
#include "smi_smic_adapter.h"
#include "smi_loop_adapter.h"

static pp_bmc_smi_mode_t smi_mode = PP_SMI_MODE_UNKNOWN;

int pp_bmc_smi_init()
{
    int r = PP_ERR;
    char* smi_mode_str;

    assert(smi_mode == PP_SMI_MODE_UNKNOWN);
    
#if !defined(PP_BMC_LOCAL_TEST)
    // LPC interfaces can exist only on the PPC
    pp_cfg_get(&smi_mode_str, "bmc.smi_mode");
    if (strcmp(smi_mode_str, PP_CD_BMC_SMI_MODE_BT_STR) == 0) {
	smi_mode = PP_SMI_MODE_BT;
	r = pp_smi_bt_init();
    } else if (strcmp(smi_mode_str, PP_CD_BMC_SMI_MODE_KCS_STR) == 0) {
	smi_mode = PP_SMI_MODE_KCS;
	r = pp_smi_kcs_init();
    } else if (strcmp(smi_mode_str, PP_CD_BMC_SMI_MODE_SMIC_STR) == 0) {
	smi_mode = PP_SMI_MODE_SMIC;
	r = pp_smi_smic_init();
    } else {
	assert(0);
    }
    free(smi_mode_str);
#else /* !defined(PP_BMC_LOCAL_TEST) */
    /* FIXME: Compiling on i386: system interface is loopback */
    smi_mode = PP_SMI_MODE_LOOPBACK;
    r = pp_smi_loop_init();
#endif /* !defined(PP_BMC_LOCAL_TEST) */

    return r;
}

void pp_bmc_smi_cleanup()
{
    assert(smi_mode != PP_SMI_MODE_UNKNOWN);
    
#if !defined(PP_BMC_LOCAL_TEST)
    switch(smi_mode) {
      case PP_SMI_MODE_BT: pp_smi_bt_cleanup(); break;
      case PP_SMI_MODE_KCS: pp_smi_kcs_cleanup(); break;
      case PP_SMI_MODE_SMIC: pp_smi_smic_cleanup(); break;
      default: assert(0);
    }
#else /* !defined(PP_BMC_LOCAL_TEST) */
    pp_smi_loop_cleanup();
#endif /* !defined(PP_BMC_LOCAL_TEST) */
    smi_mode = PP_SMI_MODE_UNKNOWN;
}

pp_bmc_smi_mode_t
pp_bmc_smi_get_mode()
{
    assert(smi_mode != PP_SMI_MODE_UNKNOWN);
    return smi_mode;
}
