#!/bin/bash

# pls. change if needed
############################
USER=admin
PASSWD=admin
ASRTDUR=5
############################

HELP_MESSAGE="Usage: `basename $0` <host> <command> <blade nr>\n\
where\n\
\t<host> \t hostname or ip address of BMC
\t<command> can be:\n\
\t\t power: \t assert power of specified blade\n\
\t\t reset: \t assert reset of specified blade\n\
\t\t bmcreset: \t assert bmc reset of specified blade\n\
\t\t switchkvm: \t switch kvm bus to specified blade\n\
\t<blade nr> \t the blade number 0 - 11"

if [ $# -ne 3 ] ; then
    echo -e "$HELP_MESSAGE" >&2
    exit 1
fi

HOST=$1

case $2 in
    power) 
	CMD=0x3b
	OPT=$ASRTDUR
	;;
    reset) 
	CMD=0x3c
	OPT=$ASRTDUR
	;;
    bmcreset) 
	CMD=0x3e
	OPT=""
	;;
    switchkvm) 
	CMD=0x3f
	OPT=""
	;;
    *)
	echo -e "$HELP_MESSAGE" >&2
	exit 1
	;;
esac

if ( echo $3 | grep -e '[0-9]\{1,2\}' ) ; then 
    BLADE=$3
else
    echo -e "$HELP_MESSAGE" >&2
    exit 1
fi

CMDLINE="ipmitool -H $HOST -U $USER -P $PASSWD raw 0x38 $CMD $BLADE $OPT"
echo $CMDLINE

eval $CMDLINE || exit 1
