/**
 * liberic_misc_i386_light.c
 *
 * (c) 2005 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 *
 * For local testing, this file is statically
 * linked in the ./test/bmc application. It contains the referred
 * function so that liberic_misc need not be linked. In final versions,
 * this file can be left away as the main program will be linked against
 * liberic_misc anyway.
 *
 * Additionally it contains functions from libpp_um and libpp_cfg. 
 * 
 */

#include <errno.h>
#include <termios.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>

#include "liberic_misc.h"
#include <liberic_notify.h>
#include <pp/um.h>
#include <pp/cfg.h>
#include <pp/vector.h>
#include <pp/bmc/debug.h>
#include <pp/smtp.h>
#include <pp/base.h>
#include <pp_gpio.h>

u_char pp_firmware_erla_version_major = 0;
u_char pp_firmware_erla_version_minor = 0;
u_char pp_firmware_erla_version_subminor = 0;
u_int pp_firmware_erla_build_nr = 7777;

/* dummy stubs, needed if BMC is not linked to eric process */
int eric_misc_trigger_board_reset(eric_session_int_id_t session UNUSED)
{
    return -10;
}

char *
eric_misc_get_hardware_rev_str(void)
{
#define MAX_HWID_STR_LEN 4
    char * revname = NULL;
    unsigned char rev = eric_misc_get_hardware_rev_int();

    if (rev != 0) {
	revname = malloc(MAX_HWID_STR_LEN);
	snprintf(revname, MAX_HWID_STR_LEN, "%02X", rev);
    }
    
    return revname;
#undef MAX_HWID_STR_LEN
}

unsigned char
eric_misc_get_hardware_rev_int()
{
	return 99;
}

int
eric_notify_post_event(const void * data UNUSED, const char *evt_name UNUSED, int evt_flag UNUSED)
{
    return 0;
}

/* dummy definitions to avoid linker errors */
void pp_rfb_disconnect_all(void);
void pp_usb_vfup_activate(void);
void pp_usb_smbmnt_close(void);
void pp_usb_vfup_add_chunk(void);
void pp_usb_smbmnt_set_param(void);
void pp_usb_smbmnt_get_status(void);
void pp_usb_ms_get_image_type(void);
void pp_usb_vfup_start(void);
void pp_usb_vfup_delete(void);
void pp_usb_ms_unset_image(void);
void pp_usb_smbmnt_start(void);
void pp_usb_vfup_complete(void);
void pp_usb_ms_get_image_size(void);
void pp_usb_smbmnt_activate(void);
void pp_usb_ms_get_image_info(void);

void pp_rfb_disconnect_all(void)    { abort(); }
void pp_usb_vfup_activate(void)     { abort(); }
void pp_usb_smbmnt_close(void)      { abort(); }
void pp_usb_vfup_add_chunk(void)    { abort(); }
void pp_usb_smbmnt_set_param(void)  { abort(); }
void pp_usb_smbmnt_get_status(void) { abort(); }
void pp_usb_ms_get_image_type(void) { abort(); }
void pp_usb_vfup_start(void)        { abort(); }
void pp_usb_vfup_delete(void)       { abort(); }
void pp_usb_ms_unset_image(void)    { abort(); }
void pp_usb_smbmnt_start(void)      { abort(); }
void pp_usb_vfup_complete(void)     { abort(); }
void pp_usb_ms_get_image_size(void) { abort(); }
void pp_usb_smbmnt_activate(void)   { abort(); }
void pp_usb_ms_get_image_info(void) { abort(); }

